/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.config.visualization;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import java.io.File;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.opt4j.core.config.Task;
import org.opt4j.core.config.visualization.ApplicationFrame;
import org.opt4j.core.config.visualization.FileOperations;

@Singleton
public class Configurator {
    public static void main(String[] args) throws Exception {
        Configurator configurator = new Configurator();
        configurator.start(args);
    }

    public void start(String[] args) throws ClassNotFoundException {
        String filename = null;
        Class<Task> taskClass = null;
        if (args.length < 1) {
            throw new RuntimeException("Specify the task class");
        }
        String taskname = args[0];
        taskClass = Class.forName(taskname).asSubclass(Task.class);
        if (args.length > 1) {
            filename = args[1];
        }
        this.main(taskClass, filename);
    }

    public Module getModule(final Class<? extends Task> taskClass) {
        Module module = new Module(){

            public void configure(Binder b) {
                b.bind(Task.class).to(taskClass);
            }
        };
        return module;
    }

    public void main(Class<? extends Task> taskClass, final String filename) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Module module = this.getModule(taskClass);
        final Injector injector = Guice.createInjector((Module[])new Module[]{module});
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationFrame frame = (ApplicationFrame)injector.getInstance(ApplicationFrame.class);
                frame.startup();
                if (filename != null) {
                    File file = new File(filename);
                    FileOperations fo = (FileOperations)injector.getInstance(FileOperations.class);
                    fo.load(file);
                }
            }
        });
    }
}

