/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.common.logger;

import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import org.opt4j.core.Individual;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.Value;
import org.opt4j.core.common.logger.AbstractLogger;
import org.opt4j.core.common.logger.Logger;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.start.Constant;

public class TsvLogger
extends AbstractLogger
implements Logger {
    protected final Archive archive;
    private final PrintWriter out;
    private long startTime = -1L;

    @Inject
    public TsvLogger(Archive archive, @Constant(value="filename", namespace=TsvLogger.class) String filename, @Constant(value="evaluationStep", namespace=TsvLogger.class) int evaluationStep, @Constant(value="iterationStep", namespace=TsvLogger.class) int iterationStep) {
        super(iterationStep, evaluationStep);
        this.archive = archive;
        this.out = this.initWriter(filename);
    }

    protected PrintWriter initWriter(String filename) {
        if (filename == null || filename.equals("")) {
            throw new IllegalArgumentException("File name must not be the empty string.");
        }
        File file = new File(filename);
        File dir = file.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        try {
            return new PrintWriter(new BufferedWriter(new FileWriter(file)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void optimizationStarted() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void logEvent(int iteration, int evaluation) {
        assert (this.startTime != -1L) : "not initialized";
        double time = ((double)System.currentTimeMillis() - (double)this.startTime) / 1000.0;
        for (Individual individual : this.archive) {
            String statistics = this.getStatistics(iteration, evaluation, time);
            String objectives = this.getIndividual(individual);
            if (objectives == null) continue;
            this.out.println(statistics + objectives);
        }
        this.out.flush();
    }

    @Override
    public void optimizationStopped() {
        this.out.close();
    }

    @Override
    public void logHeader(Collection<Objective> objectives) {
        String header = this.getCommentDelimiter() + "iteration" + this.getColumnDelimiter() + "evaluations" + this.getColumnDelimiter() + "runtime[s]";
        for (Objective objective : objectives) {
            String name = objective.getName().replaceAll("[ \n\t\r]", "_");
            header = header + this.getColumnDelimiter() + name + "[" + (Object)((Object)objective.getSign()) + "]";
        }
        this.out.println(header);
    }

    protected String getColumnDelimiter() {
        return "\t";
    }

    protected String getIndividual(Individual individual) {
        String output = "";
        Objectives objectives = individual.getObjectives();
        for (Objective objective : objectives.getKeys()) {
            String valueString;
            Value<?> value = objectives.get(objective);
            assert (value != null) : "Objective " + objective.getName() + " not set for individual " + individual;
            if (value == Objective.INFEASIBLE || value == null || value.getValue() == null) {
                valueString = "INFEASIBLE";
            } else {
                String v = value.getValue().toString();
                if (v.contains("\t")) {
                    System.err.println(this + ": Value must not contain the tab character:" + v);
                    v.replace("\t", "_");
                }
                valueString = v;
            }
            output = output + this.getColumnDelimiter() + valueString;
        }
        return output;
    }

    protected String getStatistics(int iteration, int evaluation, double time) {
        return iteration + this.getColumnDelimiter() + evaluation + this.getColumnDelimiter() + time;
    }

    protected String getCommentDelimiter() {
        return "";
    }
}

