/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opt4j.core.DoubleValue;
import org.opt4j.core.IntegerValue;
import org.opt4j.core.Objective;
import org.opt4j.core.Value;

public class Objectives
implements Iterable<Map.Entry<Objective, Value<?>>> {
    protected final SortedMap<Objective, Value<?>> map = new TreeMap();
    protected double[] array = null;

    @Override
    public Iterator<Map.Entry<Objective, Value<?>>> iterator() {
        return this.map.entrySet().iterator();
    }

    public double[] array() {
        if (this.array == null) {
            this.submit();
        }
        return this.array;
    }

    protected synchronized void submit() {
        if (this.array == null) {
            this.array = new double[this.size()];
            int i = 0;
            for (Map.Entry<Objective, Value<?>> entry : this) {
                Objective objective = entry.getKey();
                Value<?> value = entry.getValue();
                Double v = value.getDouble();
                this.array[i] = v == null ? Double.MAX_VALUE : (objective.getSign() == Objective.Sign.MAX ? -v.doubleValue() : v);
                ++i;
            }
        }
    }

    public int size() {
        return this.map.size();
    }

    public Collection<Objective> getKeys() {
        return this.map.keySet();
    }

    public Collection<Value<?>> getValues() {
        return this.map.values();
    }

    public Value<?> get(Objective objective) {
        return (Value)this.map.get(objective);
    }

    public Objective get(Value<?> value) {
        Objective objective = null;
        for (Map.Entry<Objective, Value<?>> entry : this) {
            Objective o;
            Value<?> v = entry.getValue();
            if (!value.equals(v)) continue;
            objective = o = entry.getKey();
            break;
        }
        return objective;
    }

    public void add(Objective objective, Value<?> value) {
        if (value == null) {
            this.map.put(objective, new DoubleValue(null));
        } else {
            this.map.put(objective, value);
        }
        this.array = null;
    }

    public void add(String name, Objective.Sign sign, Value<?> value) {
        this.add(new Objective(name, sign), value);
    }

    public void add(Objective objective, double value) {
        this.add(objective, new DoubleValue(value));
    }

    public void add(String name, Objective.Sign sign, double value) {
        this.add(new Objective(name, sign), value);
    }

    public void add(Objective objective, int value) {
        this.add(objective, new IntegerValue(value));
    }

    public void add(String name, Objective.Sign sign, int value) {
        this.add(new Objective(name, sign), value);
    }

    public void addAll(Objectives objectives) {
        this.map.putAll(objectives.map);
        this.array = null;
    }

    public boolean weaklyDominates(Objectives opponent) {
        double[] va = this.array();
        double[] vb = opponent.array();
        for (int i = 0; i < va.length; ++i) {
            if (!(vb[i] < va[i])) continue;
            return false;
        }
        return true;
    }

    public boolean dominates(Objectives opponent) {
        double[] va = this.array();
        double[] vb = opponent.array();
        boolean equal = true;
        for (int i = 0; i < va.length; ++i) {
            if (va[i] > vb[i]) {
                return false;
            }
            if (!(va[i] < vb[i])) continue;
            equal = false;
        }
        return !equal;
    }

    public boolean isEqual(Objectives opponent) {
        double[] va = this.array();
        double[] vb = opponent.array();
        for (int i = 0; i < va.length; ++i) {
            if (va[i] == vb[i]) continue;
            return false;
        }
        return true;
    }

    public double distance(Objectives other) {
        double[] va = this.array();
        double[] vb = other.array();
        double s = 0.0;
        for (int i = 0; i < va.length; ++i) {
            s += (va[i] - vb[i]) * (va[i] - vb[i]);
        }
        return Math.sqrt(s);
    }

    public String toString() {
        String s = "";
        for (Map.Entry<Objective, Value<?>> entry : this.map.entrySet()) {
            Objective o = entry.getKey();
            Value<?> v = entry.getValue();
            s = s + o + "=" + v + " ";
        }
        return s;
    }
}

