/*******************************************************************************
 * Copyright (c) 2014 Opt4J
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *******************************************************************************/
 
package org.opt4j.core.common.archive;

import java.util.Collection;
import java.util.Map;

import org.opt4j.core.Individual;

import com.google.inject.ImplementedBy;

/**
 * The {@code FrontDensityIndicator} is an interface for the determination of
 * density values of a front of {@link Individual}s. It is required that the
 * front consists of non-dominated {@code Individuals} only. This density
 * indicator is used for instance in the {@code Nsga2}.
 * 
 * @see Crowding
 * @author lukasiewycz
 * 
 */
@ImplementedBy(Crowding.class)
public interface FrontDensityIndicator {

	/**
	 * Returns the density values for a collection on {@code Individuals}.
	 * 
	 * @param individuals
	 *            the individuals
	 * @return a map of each individual to its density value
	 */
	public Map<Individual, Double> getDensityValues(Collection<Individual> individuals);

}
