/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.start;

import com.google.inject.Binder;
import com.google.inject.Module;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import java.io.IOException;
import java.util.Properties;
import org.opt4j.core.config.ModuleAutoFinder;
import org.opt4j.core.config.ModuleAutoFinderListener;
import org.opt4j.core.config.ModuleList;
import org.opt4j.core.config.ModuleListUser;
import org.opt4j.core.config.Task;
import org.opt4j.core.config.visualization.About;
import org.opt4j.core.config.visualization.Configurator;
import org.opt4j.core.config.visualization.DelayTask;
import org.opt4j.core.config.visualization.TasksPanel;
import org.opt4j.core.start.Opt4JAbout;
import org.opt4j.core.start.Opt4JStarter;
import org.opt4j.core.start.Opt4JTask;
import org.opt4j.core.start.Opt4JTasksPanel;

public class Opt4J
extends Configurator {
    protected static final ModuleListUser moduleList = new ModuleListUser();
    protected static Properties props = new Properties();

    public static String getVersion() {
        return props.getProperty("version");
    }

    public static String getDateISO() {
        return props.getProperty("date");
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Starting Opt4J " + Opt4J.getVersion() + " (Build " + Opt4J.getDateISO() + ")");
        if (args.length > 0 && args[0].equalsIgnoreCase("-s")) {
            SplashScreen splash = null;
            try {
                splash = SplashScreen.getSplashScreen();
            }
            catch (HeadlessException e) {
                // empty catch block
            }
            if (splash != null) {
                splash.close();
            }
            String[] a = new String[args.length - 1];
            System.arraycopy(args, 1, a, 0, a.length);
            Opt4JStarter.main(a);
        } else {
            SplashScreen splash = SplashScreen.getSplashScreen();
            SplashDecorator decorator = null;
            if (splash != null) {
                Opt4J.decorateVersionDate(splash);
                decorator = new SplashDecorator(splash);
            }
            Opt4J.searchModules(decorator);
            Opt4J configurator = new Opt4J();
            ((Configurator)configurator).start(args);
        }
    }

    protected static void decorateVersionDate(SplashScreen splash) {
        if (splash != null) {
            Graphics2D g = splash.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(new Color(242, 130, 38));
            g.setFont(new Font("SansSerif", 1, 11));
            g.drawString("version " + Opt4J.getVersion(), 170, 76);
            g.drawString(Opt4J.getDateISO(), 170, 91);
            splash.update();
        }
    }

    private static void searchModules(SplashDecorator splash) {
        ModuleAutoFinder finder = new ModuleAutoFinder();
        if (splash != null) {
            class SplashSearchDecorator
            implements ModuleAutoFinderListener {
                protected final SplashDecorator splash;

                SplashSearchDecorator(SplashDecorator splash) {
                    this.splash = splash;
                }

                @Override
                public void err(String message) {
                    this.splash.print(message, Color.RED);
                }

                @Override
                public void out(String message) {
                    this.splash.print(message, Color.GRAY.darker());
                }
            }
            SplashSearchDecorator deco = new SplashSearchDecorator(splash);
            finder.addListener(deco);
        }
        for (Class<? extends Module> module : finder.getModules()) {
            moduleList.add(module);
        }
        if (splash != null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void start(String[] args) {
        String filename = null;
        if (args.length > 0) {
            filename = args[0];
        }
        this.main(Opt4JTask.class, filename);
    }

    @Override
    public Module getModule(final Class<? extends Task> taskClass) {
        Module module = new Module(){

            public void configure(Binder b) {
                b.bind(Task.class).to(taskClass);
                b.bind(About.class).to(Opt4JAbout.class);
                b.bind(TasksPanel.class).to(Opt4JTasksPanel.class);
                b.bind(ModuleList.class).toInstance((Object)moduleList);
            }
        };
        return module;
    }

    static {
        try {
            props.load(Opt4J.class.getResourceAsStream("/main.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static class SplashDecorator {
        DelayTask delay = new DelayTask(1L);
        protected SplashScreen splash;

        public SplashDecorator(SplashScreen splash) {
            this.splash = splash;
        }

        public SplashScreen getSplash() {
            return this.splash;
        }

        public void print(final String message, final Color color) {
            this.delay.execute(new Runnable(){

                @Override
                public void run() {
                    Graphics2D g = SplashDecorator.this.splash.createGraphics();
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setColor(Color.WHITE);
                    g.setBackground(new Color(252, 230, 212));
                    g.clearRect(10, 175, 280, 20);
                    g.setClip(10, 175, 280, 20);
                    g.setColor(color);
                    g.setFont(new Font("SansSerif", 1, 9));
                    g.drawString(message, 12, 188);
                    SplashDecorator.this.splash.update();
                }
            });
        }
    }
}

