/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.config;

import com.google.inject.Inject;
import com.google.inject.Module;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.opt4j.core.config.ModuleAutoFinderListener;
import org.opt4j.core.config.ModuleList;
import org.opt4j.core.config.Starter;
import org.opt4j.core.config.Transformer;
import org.opt4j.core.config.annotations.Ignore;
import org.opt4j.core.start.Opt4JModule;

public class ModuleAutoFinder
implements ModuleList {
    protected final Transformer<Class<? extends Module>, Boolean> accept;
    protected final Transformer<Class<? extends Module>, Boolean> ignore;
    protected final Set<ModuleAutoFinderListener> listeners = new CopyOnWriteArraySet<ModuleAutoFinderListener>();
    protected ClassLoader classLoader;

    @Inject
    public ModuleAutoFinder() {
        this(null, null);
    }

    public ModuleAutoFinder(Transformer<Class<? extends Module>, Boolean> accept, Transformer<Class<? extends Module>, Boolean> ignore) {
        this.accept = accept != null ? accept : new AllTrue();
        this.ignore = ignore != null ? ignore : new AllFalse();
    }

    @Override
    public Collection<Class<? extends Module>> getModules() {
        return this.getAll();
    }

    protected Collection<Class<? extends Module>> getAll() {
        Starter starter = new Starter();
        Collection<File> files = starter.addPlugins();
        this.classLoader = ClassLoader.getSystemClassLoader();
        String paths = System.getProperty("java.class.path");
        StringTokenizer st = new StringTokenizer(paths, ";\n:");
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            File f = new File(path);
            if (!f.exists()) continue;
            try {
                f = f.getCanonicalFile();
                files.add(f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ArrayList classes = new ArrayList();
        for (File file : files) {
            if (this.isJar(file)) {
                try {
                    classes.addAll(this.getAllClasses(new ZipFile(file)));
                }
                catch (ZipException zipException) {
                    zipException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (UnsupportedClassVersionError unsupportedClassVersionError) {
                    System.err.println(file + " not supported: bad version number");
                }
                continue;
            }
            classes.addAll(this.getAllClasses(file));
        }
        ArrayList<Class<? extends Module>> modules = new ArrayList<Class<? extends Module>>();
        for (Class clazz : classes) {
            Class<Module> module;
            Ignore i;
            if (!Opt4JModule.class.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers()) || (i = (module = clazz.asSubclass(Module.class)).getAnnotation(Ignore.class)) != null || module.isAnonymousClass() || !this.accept.transform(module).booleanValue() || this.ignore.transform(module).booleanValue()) continue;
            modules.add(module);
            this.invokeOut("Add module: " + module.toString());
        }
        return modules;
    }

    protected boolean isJar(File file) {
        if (file.isDirectory()) {
            return false;
        }
        try {
            ZipFile zf = new ZipFile(file);
            zf.close();
            return true;
        }
        catch (ZipException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    protected List<Class<?>> getAllClasses(File directory) {
        return this.getAllClasses(directory, directory);
    }

    protected List<Class<?>> getAllClasses(File root, File file) {
        ArrayList classes;
        block5: {
            block4: {
                classes = new ArrayList();
                if (!file.isDirectory()) break block4;
                for (File f : file.listFiles()) {
                    classes.addAll(this.getAllClasses(root, f));
                }
                break block5;
            }
            int rootLength = root.getAbsolutePath().length();
            String s = file.getAbsolutePath().substring(rootLength + 1);
            s = s.replace("\\", ".");
            if (!(s = s.replace("/", ".")).endsWith(".class")) break block5;
            s = s.substring(0, s.length() - 6);
            try {
                Class<?> clazz = this.classLoader.loadClass(s);
                classes.add(clazz);
                this.invokeOut("Check: " + clazz.getName());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (UnsupportedClassVersionError e) {
                System.err.println(s + " not supported: bad version number");
                this.invokeErr(s + " not supported");
            }
        }
        return classes;
    }

    protected List<Class<?>> getAllClasses(ZipFile zipFile) {
        this.invokeOut(zipFile.toString());
        ArrayList classes = new ArrayList();
        ArrayList<? extends ZipEntry> entries = Collections.list(zipFile.entries());
        for (int i = 0; i < entries.size(); ++i) {
            ZipEntry entry = (ZipEntry)entries.get(i);
            String s = entry.getName();
            if (!s.endsWith(".class")) continue;
            s = s.replace("/", ".");
            s = s.substring(0, s.length() - 6);
            try {
                Class<?> clazz = this.classLoader.loadClass(s);
                classes.add(clazz);
                this.invokeOut("Check: " + clazz.getName());
                continue;
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            catch (NoClassDefFoundError e) {
                continue;
            }
            catch (UnsupportedClassVersionError e) {
                System.err.println(s + " not supported: bad version number");
                this.invokeErr(s + " not supported");
            }
        }
        return classes;
    }

    protected void invokeOut(String message) {
        for (ModuleAutoFinderListener listener : this.listeners) {
            listener.out(message);
        }
    }

    protected void invokeErr(String message) {
        for (ModuleAutoFinderListener listener : this.listeners) {
            listener.out(message);
        }
    }

    public void addListener(ModuleAutoFinderListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ModuleAutoFinderListener listener) {
        this.listeners.remove(listener);
    }

    private static class AllFalse
    implements Transformer<Class<? extends Module>, Boolean> {
        private AllFalse() {
        }

        @Override
        public Boolean transform(Class<? extends Module> arg) {
            return false;
        }
    }

    private static class AllTrue
    implements Transformer<Class<? extends Module>, Boolean> {
        private AllTrue() {
        }

        @Override
        public Boolean transform(Class<? extends Module> arg) {
            return true;
        }
    }
}

