/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.common.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opt4j.core.Individual;
import org.opt4j.core.common.archive.FrontDensityIndicator;

public class Crowding
implements FrontDensityIndicator {
    private Map<Individual, Double> getValues(Collection<Individual> individuals) {
        HashMap<Individual, Double> map = new HashMap<Individual, Double>();
        ArrayList<Individual> list = new ArrayList<Individual>(individuals);
        for (Individual individual : list) {
            map.put(individual, 0.0);
        }
        int m = ((Individual)list.get(0)).getObjectives().array().length;
        for (int i = 0; i < m; ++i) {
            final int dim = i;
            Collections.sort(list, new Comparator<Individual>(){

                @Override
                public int compare(Individual o1, Individual o2) {
                    double i1 = o1.getObjectives().array()[dim];
                    double i2 = o2.getObjectives().array()[dim];
                    return (int)Math.signum(i1 - i2);
                }
            });
            Individual minIndividual = (Individual)list.get(0);
            Individual maxIndividual = (Individual)list.get(list.size() - 1);
            double diff = maxIndividual.getObjectives().array()[dim] - minIndividual.getObjectives().array()[dim];
            if (!(diff > 0.0)) continue;
            map.put(minIndividual, (Double)Double.MAX_VALUE);
            map.put(maxIndividual, (Double)Double.MAX_VALUE);
            for (int j = 1; j < list.size() - 1; ++j) {
                double p = ((Individual)list.get(j - 1)).getObjectives().array()[dim];
                double n = ((Individual)list.get(j + 1)).getObjectives().array()[dim];
                Individual ind = (Individual)list.get(j);
                map.put(ind, (Double)map.get(ind) + (n - p) / diff);
            }
        }
        return map;
    }

    public List<Individual> order(final Map<Individual, Double> values) {
        ArrayList<Individual> list = new ArrayList<Individual>(values.keySet());
        Collections.sort(list, new Comparator<Individual>(){

            @Override
            public int compare(Individual o1, Individual o2) {
                return ((Double)values.get(o2)).compareTo((Double)values.get(o1));
            }
        });
        return list;
    }

    @Override
    public Map<Individual, Double> getDensityValues(Collection<Individual> individuals) {
        return this.getValues(individuals);
    }
}

