/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.config.visualization;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opt4j.core.config.PropertyModule;
import org.opt4j.core.config.visualization.SetListener;

@Singleton
public class SelectedModules
extends TreeSet<PropertyModule> {
    protected Set<SetListener> listeners = new CopyOnWriteArraySet<SetListener>();

    @Override
    public boolean add(PropertyModule module) {
        boolean b = super.add(module);
        for (SetListener listener : this.listeners) {
            listener.moduleAdded(this, module);
        }
        return b;
    }

    @Override
    public boolean addAll(Collection<? extends PropertyModule> modules) {
        boolean r = false;
        for (PropertyModule propertyModule : modules) {
            r = this.add(propertyModule) || r;
        }
        return r;
    }

    @Override
    public boolean remove(Object o) {
        boolean b = super.remove(o);
        if (b) {
            for (SetListener listener : this.listeners) {
                listener.moduleRemoved(this, (PropertyModule)o);
            }
        }
        return b;
    }

    @Override
    public void clear() {
        ArrayList<PropertyModule> modules = new ArrayList<PropertyModule>();
        modules.addAll(this);
        for (PropertyModule module : modules) {
            this.remove(module);
        }
    }

    public void addListener(SetListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SetListener listener) {
        this.listeners.remove(listener);
    }
}

