/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.config.visualization;

import com.google.inject.Inject;
import com.google.inject.Module;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import org.opt4j.core.config.Icons;
import org.opt4j.core.config.ModuleRegister;
import org.opt4j.core.config.PropertyModule;
import org.opt4j.core.config.annotations.Category;
import org.opt4j.core.config.annotations.Multi;
import org.opt4j.core.config.annotations.Parent;
import org.opt4j.core.config.visualization.Format;
import org.opt4j.core.config.visualization.ModuleTransferable;
import org.opt4j.core.config.visualization.ModulesPanel;
import org.opt4j.core.config.visualization.SelectedModules;

public class DefaultModulesPanel
extends ModulesPanel {
    protected final Format format;
    protected final ModuleRegister allModules;
    protected final SelectedModules selectedModules;
    protected final RootTreeNode root = new RootTreeNode(true);
    protected JTree tree = null;
    protected final JPopupMenu moduleMenu = new JPopupMenu();
    protected MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                DefaultModulesPanel.this.displayMenu(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Object object;
            int count = e.getClickCount();
            if (e.isPopupTrigger()) {
                DefaultModulesPanel.this.displayMenu(e);
            } else if (count > 1 && (object = DefaultModulesPanel.this.tree.getLastSelectedPathComponent()) instanceof ModuleTreeNode) {
                ModuleTreeNode node = (ModuleTreeNode)object;
                PropertyModule pmodule = node.getModule();
                if (DefaultModulesPanel.this.selectedModules.contains(pmodule)) {
                    DefaultModulesPanel.this.remove(pmodule);
                } else {
                    DefaultModulesPanel.this.add(pmodule);
                }
            }
        }
    };

    @Inject
    public DefaultModulesPanel(Format format, ModuleRegister allModules, SelectedModules selectedModules) {
        this.format = format;
        this.allModules = allModules;
        this.selectedModules = selectedModules;
    }

    @Override
    public void startup() {
        this.tree = new MyTree(this.root);
        this.tree.setToggleClickCount(1000);
        this.tree.addMouseListener(this.mouseListener);
        this.tree.setCellRenderer(new TreeCellRenderer());
        this.tree.setSelectionModel(null);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        JScrollPane scroll = new JScrollPane(this.tree, 22, 30);
        this.setLayout(new BorderLayout());
        this.add((Component)scroll, "Center");
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    DefaultModulesPanel.this.populateTree();
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    private Class<?> getCategory(Class<?> clazz, boolean include) {
        if (include && this.isCategory(clazz)) {
            return clazz;
        }
        if (clazz.equals(Object.class)) {
            return null;
        }
        if (clazz.getAnnotation(Parent.class) != null) {
            Class<?> pClass = clazz.getAnnotation(Parent.class).value();
            return pClass;
        }
        assert (clazz.getSuperclass() != null) : clazz;
        return this.getCategory(clazz.getSuperclass(), true);
    }

    private boolean isCategory(Class<?> clazz) {
        Category category = clazz.getAnnotation(Category.class);
        return category != null;
    }

    protected void populateTree() {
        boolean removed;
        int size;
        HashMap map = new HashMap();
        for (Class<? extends Module> module : this.allModules) {
            Class<?> category = this.getCategory(module, false);
            assert (module != category) : module;
            map.put(module, category);
        }
        do {
            size = map.size();
            HashSet values = new HashSet(map.values());
            for (Class cat : values) {
                if (cat == null) continue;
                Class<?> category = this.getCategory(cat, false);
                map.put(cat, category);
            }
        } while (map.size() != size);
        HashMap<Class, CategoryTreeNode> ctn = new HashMap<Class, CategoryTreeNode>();
        HashMap<Class, CategoryTreeNode> mtn = new HashMap<Class, CategoryTreeNode>();
        HashMap<Class, CategoryTreeNode> atn = new HashMap<Class, CategoryTreeNode>();
        for (Class clazz : map.keySet()) {
            UserNode node;
            if (this.isCategory(clazz)) {
                node = new CategoryTreeNode(clazz);
                ctn.put(clazz, (CategoryTreeNode)node);
                continue;
            }
            node = new ModuleTreeNode(clazz);
            mtn.put(clazz, (CategoryTreeNode)node);
        }
        atn.putAll(ctn);
        atn.putAll(mtn);
        CategoryTreeNode def = new CategoryTreeNode(Default.class);
        this.root.add(def);
        for (Map.Entry entry : atn.entrySet()) {
            Class clazz = (Class)entry.getKey();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)entry.getValue();
            Class category = (Class)map.get(clazz);
            if (category == null) {
                if (this.isCategory(clazz)) {
                    this.root.add(node);
                    continue;
                }
                def.add(node);
                continue;
            }
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)atn.get(category);
            assert (n != null && n != node) : clazz + " " + category;
            n.add(node);
        }
        while (removed = this.removeEmptyCategories(this.root)) {
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultModulesPanel.this.tree.setSelectionModel(new DefaultTreeSelectionModel());
                DefaultModulesPanel.this.tree.getSelectionModel().setSelectionMode(1);
                DefaultModulesPanel.this.root.setLoading(false);
                DefaultModulesPanel.this.sort(DefaultModulesPanel.this.tree);
                DefaultModulesPanel.this.tree.expandRow(0);
            }
        });
        this.revalidate();
        this.repaint();
    }

    private boolean removeEmptyCategories(DefaultMutableTreeNode current) {
        if (!current.children().hasMoreElements()) {
            return false;
        }
        TreeNode node = current.getFirstChild();
        boolean removed = false;
        while (node != null) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)node;
            node = current.getChildAfter(n);
            if (n.isLeaf()) {
                if (!(n instanceof CategoryTreeNode) || n.getChildCount() != 0) continue;
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)n.getParent();
                parent.remove(n);
                removed = true;
                continue;
            }
            removed = removed || this.removeEmptyCategories(n);
        }
        return removed;
    }

    protected void add(PropertyModule pm) {
        Module module = pm.getModule();
        if (module.getClass().getAnnotation(Multi.class) != null) {
            try {
                Module m2 = (Module)module.getClass().newInstance();
                PropertyModule pm2 = new PropertyModule(m2);
                this.selectedModules.add(pm2);
            }
            catch (InstantiationException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
        } else {
            this.selectedModules.add(pm);
        }
    }

    protected void remove(PropertyModule pm) {
        this.selectedModules.remove(pm);
    }

    protected void displayMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            Point pt = e.getPoint();
            this.tree.setSelectionPath(this.tree.getPathForLocation(pt.x, pt.y));
            Object object = this.tree.getLastSelectedPathComponent();
            if (object instanceof ModuleTreeNode) {
                ModuleTreeNode node = (ModuleTreeNode)object;
                final PropertyModule module = node.getModule();
                this.moduleMenu.removeAll();
                JMenuItem add = new JMenuItem("Add Module", Icons.getIcon("icons/add.png"));
                add.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DefaultModulesPanel.this.add(module);
                    }
                });
                JMenuItem remove = new JMenuItem("Remove Module", Icons.getIcon("icons/delete.png"));
                remove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DefaultModulesPanel.this.remove(module);
                    }
                });
                if (this.selectedModules.contains(module)) {
                    add.setEnabled(false);
                } else {
                    remove.setEnabled(false);
                }
                this.moduleMenu.add(add);
                this.moduleMenu.add(remove);
                this.moduleMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    protected void sort(JTree tree) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        this.sort(root);
    }

    protected void sort(DefaultMutableTreeNode node) {
        if (!node.children().hasMoreElements()) {
            return;
        }
        ArrayList<UserNode> nodes = new ArrayList<UserNode>();
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            UserNode n = (UserNode)children.nextElement();
            nodes.add(n);
        }
        Collections.sort(nodes, new Comparator<UserNode>(){

            @Override
            public int compare(UserNode o1, UserNode o2) {
                boolean cat1 = o1 instanceof CategoryTreeNode;
                boolean cat2 = o2 instanceof CategoryTreeNode;
                if (cat1 && !cat2) {
                    return -1;
                }
                if (!cat1 && cat2) {
                    return 1;
                }
                return o1.toString().compareTo(o2.toString());
            }
        });
        node.removeAllChildren();
        for (UserNode n : nodes) {
            node.add(n);
            this.sort(n);
        }
    }

    protected static class MyTree
    extends JTree
    implements DragGestureListener {
        DragSource dragSource = null;
        protected DragSourceListener dragSourceListener = new DragSourceAdapter(){};

        public MyTree(TreeNode root) {
            super(root);
            this.dragSource = new DragSource();
            this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            TreeNode node = (TreeNode)this.getLastSelectedPathComponent();
            if (node instanceof ModuleTreeNode) {
                ModuleTreeNode moduleNode = (ModuleTreeNode)node;
                PropertyModule module = moduleNode.getModule();
                ModuleTransferable transferable = new ModuleTransferable(module);
                this.dragSource.startDrag(dge, DragSource.DefaultMoveDrop, transferable, this.dragSourceListener);
            }
        }
    }

    protected static class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        protected TreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component comp = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            ImageIcon icon = null;
            String tooltip = null;
            if (value instanceof UserNode) {
                UserNode userNode = (UserNode)value;
                icon = userNode.getIcon();
                tooltip = userNode.getTooltip();
            }
            if (icon == null) {
                icon = Icons.getDefault();
            }
            this.setIcon(icon);
            this.setToolTipText(tooltip);
            return comp;
        }
    }

    @Category(value="Default")
    class Default {
        Default() {
        }
    }

    protected class CategoryTreeNode
    extends UserNode {
        public CategoryTreeNode(Class<?> clazz) {
            super(clazz);
        }

        @Override
        public Class<?> getType() {
            return (Class)this.userObject;
        }

        @Override
        public String toString() {
            return DefaultModulesPanel.this.format.getName(this.getType());
        }

        @Override
        public ImageIcon getIcon() {
            return DefaultModulesPanel.this.format.asFolder(super.getIcon());
        }
    }

    protected class ModuleTreeNode
    extends UserNode {
        public ModuleTreeNode(Class<? extends Module> module) {
            super(module);
        }

        public PropertyModule getModule() {
            return DefaultModulesPanel.this.allModules.get((Class)this.userObject);
        }

        @Override
        public Class<?> getType() {
            return (Class)this.userObject;
        }
    }

    protected class RootTreeNode
    extends UserNode {
        public RootTreeNode(boolean b) {
            super((Object)b);
        }

        public void setLoading(boolean b) {
            this.userObject = b;
        }

        public boolean isLoading() {
            return (Boolean)this.userObject;
        }

        @Override
        public ImageIcon getIcon() {
            if (this.isLoading()) {
                ImageIcon icon = Icons.getIcon("icons/loading.gif");
                icon.setImageObserver(DefaultModulesPanel.this.tree);
                return icon;
            }
            return DefaultModulesPanel.this.format.asFolder(null);
        }

        @Override
        public String toString() {
            if (this.isLoading()) {
                return "Loading";
            }
            return "Modules";
        }

        @Override
        public String getTooltip() {
            return null;
        }

        @Override
        public Class<?> getType() {
            return null;
        }
    }

    protected abstract class UserNode
    extends DefaultMutableTreeNode {
        public UserNode(Object object) {
            super(object);
        }

        @Override
        public String toString() {
            return DefaultModulesPanel.this.format.getName(this.getType());
        }

        public ImageIcon getIcon() {
            return DefaultModulesPanel.this.format.getIcon(this.getType());
        }

        public String getTooltip() {
            return DefaultModulesPanel.this.format.getTooltip(this.getType());
        }

        public abstract Class<?> getType();
    }
}

