/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.config;

import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opt4j.core.config.PropertyModule;
import org.opt4j.core.config.TaskStateListener;

public abstract class Task
implements Callable<Void> {
    protected State state = State.WAITING;
    protected Exception e = null;
    protected final List<Module> modules = new ArrayList<Module>();
    protected boolean isInit = false;
    protected final Set<TaskStateListener> listeners = new CopyOnWriteArraySet<TaskStateListener>();

    public void init(Module ... modules) {
        this.init(Arrays.asList(modules));
    }

    public void init(Collection<Module> modules) {
        for (Module module : modules) {
            if (module instanceof PropertyModule) {
                PropertyModule pModule = (PropertyModule)module;
                this.modules.add(pModule.clone());
                continue;
            }
            this.modules.add(module);
        }
        this.isInit = true;
    }

    public abstract void execute() throws Exception;

    @Override
    public Void call() throws Exception {
        this.setState(State.EXECUTING);
        try {
            this.execute();
        }
        catch (Error e) {
            this.e = new RuntimeException(e);
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            this.e = e;
            e.printStackTrace();
            throw e;
        }
        finally {
            this.setState(State.DONE);
        }
        return null;
    }

    public Exception getException() {
        return this.e;
    }

    public State getState() {
        return this.state;
    }

    protected void setState(State state) {
        this.state = state;
        for (TaskStateListener listener : this.listeners) {
            listener.stateChanged(this);
        }
    }

    public String toString() {
        return "";
    }

    public void addStateListener(TaskStateListener listener) {
        this.listeners.add(listener);
    }

    public void removeStateListener(TaskStateListener listener) {
        this.listeners.remove(listener);
    }

    public Collection<Module> getModules() {
        ArrayList<Module> clones = new ArrayList<Module>();
        for (Module module : this.modules) {
            PropertyModule pModule = module instanceof PropertyModule ? (PropertyModule)module : new PropertyModule(module);
            clones.add(pModule.clone());
        }
        return clones;
    }

    public static enum State {
        WAITING,
        EXECUTING,
        DONE;

    }
}

