/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.config;

import com.google.inject.Binder;
import com.google.inject.Module;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.opt4j.core.config.BooleanRequirement;
import org.opt4j.core.config.EnumRequirement;
import org.opt4j.core.config.JNode;
import org.opt4j.core.config.Property;
import org.opt4j.core.config.Requirement;
import org.opt4j.core.config.annotations.Ignore;
import org.opt4j.core.config.annotations.Info;
import org.opt4j.core.config.annotations.Multi;
import org.opt4j.core.config.annotations.Order;
import org.opt4j.core.config.annotations.Required;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Ignore
public final class PropertyModule
implements Module,
Serializable,
Comparable<PropertyModule> {
    protected final Module module;
    protected final List<Property> properties = new ArrayList<Property>();
    protected static int c = 0;
    public final int id;

    public static Object toEnumElement(String name, Class<? extends Enum> type) {
        for (Enum e : type.getEnumConstants()) {
            if (!e.name().equalsIgnoreCase(name)) continue;
            return e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyModule(Module module) {
        Property property;
        PropertyModule propertyModule = this;
        synchronized (propertyModule) {
            this.id = c++;
        }
        this.module = module;
        if (module instanceof PropertyModule) {
            throw new IllegalArgumentException("PropertyModule can not decorate a PropertyModule");
        }
        HashMap<String, Method> getters = new HashMap<String, Method>();
        HashMap<String, Method> setters = new HashMap<String, Method>();
        HashMap types = new HashMap();
        HashMap annotations = new HashMap();
        for (Method method : module.getClass().getMethods()) {
            String name = method.getName();
            boolean get = name.startsWith("get");
            boolean is = name.startsWith("is");
            try {
                if (!get && !is) continue;
                if (get) {
                    name = name.substring(3);
                } else if (is) {
                    name = name.substring(2);
                }
                Class<?> type = method.getReturnType();
                Method setter = module.getClass().getMethod("set" + name, type);
                char[] letters = name.toCharArray();
                letters[0] = Character.toLowerCase(letters[0]);
                name = new String(letters);
                HashSet<Annotation> a = new HashSet<Annotation>();
                Class<?> clazz = module.getClass();
                while (!clazz.equals(Object.class)) {
                    try {
                        Field field = clazz.getDeclaredField(name);
                        for (Annotation annotation : field.getAnnotations()) {
                            a.add(annotation);
                        }
                        break;
                    }
                    catch (NoSuchFieldException e) {
                        clazz = clazz.getSuperclass();
                    }
                }
                for (Annotation annotation : method.getAnnotations()) {
                    a.add(annotation);
                }
                for (Annotation annotation : setter.getAnnotations()) {
                    a.add(annotation);
                }
                getters.put(name, method);
                setters.put(name, setter);
                types.put(name, type);
                annotations.put(name, a);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        for (String name : getters.keySet()) {
            Method getter = (Method)getters.get(name);
            Method setter = (Method)setters.get(name);
            Class type = (Class)types.get(name);
            Collection anno = (Collection)annotations.get(name);
            Property property2 = new Property(module, name, type, getter, setter, anno);
            this.properties.add(property2);
        }
        for (String name : getters.keySet()) {
            Collection a = (Collection)annotations.get(name);
            property = this.getProperty(name);
            for (Annotation annotation : a) {
                if (annotation instanceof Info) {
                    Info info = (Info)annotation;
                    property.setInfo(info.value());
                    continue;
                }
                if (annotation instanceof Order) {
                    Order order = (Order)annotation;
                    property.setOrder(order.value());
                    continue;
                }
                if (!(annotation instanceof Required)) continue;
                Required required = (Required)annotation;
                Property p = this.getProperty(required.property());
                if (p == null) {
                    throw new NullPointerException("Unknown property " + required.property() + " in annotation " + required + " in module " + this.getClass());
                }
                Class<?> type = p.getType();
                if (type.isEnum()) {
                    String[] values = required.elements();
                    HashSet<Object> elements = new HashSet<Object>();
                    for (String value : values) {
                        elements.add(PropertyModule.toEnumElement(value, type.asSubclass(Enum.class)));
                    }
                    EnumRequirement requirement = new EnumRequirement(p, elements);
                    property.addRequirement(requirement);
                    continue;
                }
                if (!type.equals(Boolean.TYPE)) continue;
                boolean value = required.value();
                BooleanRequirement requirement = new BooleanRequirement(p, value);
                property.addRequirement(requirement);
            }
        }
        HashMap<Property, ArrayList<Property>> hierarchy = new HashMap<Property, ArrayList<Property>>();
        for (Property property3 : this.properties) {
            Property parent = null;
            for (Requirement requirement : property3.getRequirements()) {
                parent = requirement.getProperty();
            }
            assert (parent != property3);
            ArrayList<Property> level = (ArrayList<Property>)hierarchy.get(parent);
            if (level == null) {
                level = new ArrayList<Property>();
                hierarchy.put(parent, level);
            }
            level.add(property3);
        }
        for (List level : hierarchy.values()) {
            final class PropertyComparator
            implements Comparator<Property> {
                PropertyComparator() {
                }

                @Override
                public int compare(Property o1, Property o2) {
                    Integer value2;
                    Integer value1 = o1.getOrder();
                    if (!value1.equals(value2 = Integer.valueOf(o2.getOrder()))) {
                        return value1.compareTo(value2);
                    }
                    String s1 = o1.getName();
                    String s2 = o2.getName();
                    return s1.compareTo(s2);
                }
            }
            Collections.sort(level, new PropertyComparator());
        }
        this.properties.clear();
        LinkedList added = new LinkedList();
        added.add(null);
        while (!added.isEmpty()) {
            Property property4 = (Property)added.pop();
            if (!hierarchy.containsKey(property4)) continue;
            List level = (List)hierarchy.get(property4);
            if (property4 == null) {
                this.properties.addAll(level);
            } else {
                int index = this.properties.indexOf(property4);
                this.properties.addAll(index + 1, level);
            }
            added.addAll(level);
        }
        Iterator<Property> it = this.properties.iterator();
        while (it.hasNext()) {
            property = it.next();
            Ignore ignore = property.getAnnotation(Ignore.class);
            if (ignore == null) continue;
            it.remove();
        }
    }

    public void configure(Binder binder) {
        this.module.configure(binder);
    }

    public Module getModule() {
        return this.module;
    }

    public Property getProperty(String name) {
        for (Property property : this.properties) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public String toString() {
        String s = "Module " + this.module.getClass().getName() + " ";
        for (Property property : this.properties) {
            s = s + property.getName() + "=\"" + property.getValue() + "\" ";
        }
        return s;
    }

    public void setConfiguration(Node node) {
        String value;
        String key;
        JNode xode = new JNode(node);
        HashMap<String, String> values = new HashMap<String, String>();
        List<JNode> propertyNodes = xode.getChildren("property");
        for (JNode propertyNode : propertyNodes) {
            key = propertyNode.getAttribute("name");
            value = null;
            if (propertyNode.hasText()) {
                value = propertyNode.getText();
            } else if (propertyNode.hasAttribute("value")) {
                value = propertyNode.getAttribute("value");
            }
            values.put(key, value);
        }
        for (Property property : this.properties) {
            key = property.getName();
            if (!values.containsKey(key)) continue;
            value = (String)values.get(key);
            try {
                property.setValue(value);
            }
            catch (InvocationTargetException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public Node getConfiguration(Document document) {
        JNode node = new JNode(document, "module");
        node.setAttribute("class", this.module.getClass().getName());
        for (Property property : this.properties) {
            try {
                JNode p = node.appendChild("property");
                String name = property.getName();
                Object value = property.getValue();
                p.setAttribute("name", name);
                if (value == null) continue;
                if (value instanceof Class) {
                    p.setText(((Class)value).getCanonicalName());
                    continue;
                }
                p.setText(value.toString());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return node.getNode();
    }

    public PropertyModule clone() {
        try {
            Module module = (Module)this.module.getClass().newInstance();
            PropertyModule propertyModule = new PropertyModule(module);
            for (Property p : this.getProperties()) {
                Property property = propertyModule.getProperty(p.getName());
                property.setValue(p.getValue());
            }
            return propertyModule;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.module.getClass().toString());
    }

    @Override
    public int compareTo(PropertyModule other) {
        Class<?> clazz1 = this.getModule().getClass();
        Class<?> clazz2 = other.getModule().getClass();
        String classname1 = clazz1.getName();
        String classname2 = clazz2.getName();
        if (!clazz1.equals(clazz2)) {
            return classname1.compareTo(classname2);
        }
        Multi multi = clazz1.getAnnotation(Multi.class);
        if (multi == null) {
            return 0;
        }
        return this.id - other.id;
    }

    public int hashCode() {
        return this.module.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyModule other = (PropertyModule)obj;
        return this.compareTo(other) == 0;
    }
}

