/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.config;

import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.opt4j.core.config.ModuleList;
import org.opt4j.core.config.PropertyModule;
import org.opt4j.core.config.annotations.Multi;

@Singleton
public class ModuleRegister
implements Iterable<Class<? extends Module>> {
    protected final Map<Class<? extends Module>, PropertyModule> map = Collections.synchronizedMap(new HashMap());
    protected final Set<Class<? extends Module>> set = Collections.synchronizedSet(new HashSet());
    protected final ModuleList finder;
    protected boolean isInit = false;

    @Inject
    public ModuleRegister(ModuleList finder) {
        this.finder = finder;
    }

    @Override
    public synchronized Iterator<Class<? extends Module>> iterator() {
        this.checkInit();
        return this.set.iterator();
    }

    public synchronized int size() {
        this.checkInit();
        return this.set.size();
    }

    public PropertyModule get(Class<? extends Module> clazz) {
        PropertyModule propertyModule = null;
        if (clazz.getAnnotation(Multi.class) == null && this.map.containsKey(clazz)) {
            propertyModule = this.map.get(clazz);
        } else {
            try {
                Module module = clazz.newInstance();
                propertyModule = new PropertyModule(module);
                this.map.put(clazz, propertyModule);
            }
            catch (InstantiationException e) {
                System.err.println("Failed to create an instance of module " + clazz + ".");
            }
            catch (IllegalAccessException e) {
                System.err.println("Failed to create an instance of module " + clazz + ".");
            }
        }
        return propertyModule;
    }

    private synchronized void checkInit() {
        while (!this.isInit) {
            System.out.print("Searching Modules ... ");
            for (Class<? extends Module> clazz : this.finder.getModules()) {
                this.set.add(clazz);
                try {
                    clazz.newInstance();
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            System.out.println("Done");
            this.isInit = true;
        }
    }
}

