/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.config.visualization;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

class DialogLayout
implements LayoutManager {
    public static final int DEFAULT_HGAP = 10;
    public static final int DEFAULT_VGAP = 5;
    protected final int hGap;
    protected final int vGap;

    public DialogLayout() {
        this(10, 5);
    }

    public DialogLayout(int hGap, int vGap) {
        this.hGap = hGap;
        this.vGap = vGap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int divider = this.getDivider(parent);
        int w = 0;
        int h = 0;
        for (int k = 1; k < parent.getComponentCount(); k += 2) {
            Component comp = parent.getComponent(k);
            Dimension d = comp.getMinimumSize();
            w = Math.max(w, d.width);
            h += d.height + this.vGap;
        }
        Insets insets = parent.getInsets();
        return new Dimension(divider + w + insets.left + insets.right, (h += this.vGap) + insets.top + insets.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        int divider = this.getDivider(parent);
        Insets insets = parent.getInsets();
        int w = parent.getWidth() - insets.left - insets.right - divider;
        int x = insets.left;
        int y = insets.top;
        for (int k = 1; k < parent.getComponentCount(); k += 2) {
            Component comp1 = parent.getComponent(k - 1);
            Component comp2 = parent.getComponent(k);
            Dimension d = comp2.getPreferredSize();
            comp1.setBounds(x, y, divider - this.hGap, d.height);
            comp2.setBounds(x + divider, y, w, d.height);
            y += d.height + this.vGap;
        }
    }

    protected int getDivider(Container parent) {
        Insets insets = parent.getInsets();
        int half = (parent.getWidth() - insets.left - insets.right) / 2;
        int divider = 0;
        for (int k = 0; k < parent.getComponentCount(); k += 2) {
            Component comp = parent.getComponent(k);
            Dimension d = comp.getPreferredSize();
            divider = Math.max(divider, d.width);
        }
        return Math.max(divider += this.hGap, half);
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hGap + ",vgap=" + this.vGap + "]";
    }
}

