/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.config.visualization;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;

class ClipboardFrame
extends JFrame
implements ClipboardOwner {
    private static final long serialVersionUID = 1L;

    public ClipboardFrame(final String content) {
        JTextPane text = new JTextPane(){
            private static final long serialVersionUID = 1L;

            @Override
            public void processMouseEvent(MouseEvent me) {
                switch (me.getID()) {
                    case 500: {
                        switch (me.getButton()) {
                            case 1: {
                                StringSelection stringSelection = new StringSelection(content);
                                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                                clipboard.setContents(stringSelection, ClipboardFrame.this);
                            }
                        }
                        ClipboardFrame.this.dispose();
                    }
                }
            }
        };
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                ClipboardFrame.this.dispose();
            }
        });
        text.setCaretColor(Color.WHITE);
        text.setEditable(false);
        text.setHighlighter(null);
        text.setBorder(BorderFactory.createLineBorder(Color.WHITE, 4));
        StyledDocument doc = text.getStyledDocument();
        try {
            doc.insertString(doc.getLength(), content, null);
            doc.remove(doc.getLength() - 1, 1);
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(text);
        panel.add("South", new JLabel(" left-click: copy to clipboard"));
        panel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        this.add(panel);
        this.setUndecorated(true);
        Point p = MouseInfo.getPointerInfo().getLocation();
        this.setLocation((int)((Point2D)p).getX() - 8, (int)((Point2D)p).getY() - 8);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

