/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.config;

import com.google.inject.Module;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.opt4j.core.config.ClassPath;
import org.opt4j.core.config.ModuleAutoFinder;
import org.opt4j.core.config.ModuleLoader;
import org.opt4j.core.config.ModuleRegister;
import org.opt4j.core.config.Task;

public class Starter {
    public static void main(String[] args) throws Exception {
        Starter starter = new Starter();
        starter.execute(args);
    }

    public void execute(String[] args) throws Exception {
        this.addPlugins();
        String taskname = args[0];
        Class<Task> taskClass = Class.forName(taskname).asSubclass(Task.class);
        String[] filenames = new String[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            filenames[i - 1] = args[i];
        }
        this.execute(taskClass, filenames);
    }

    public void execute(Class<? extends Task> taskClass, String[] filenames) throws Exception {
        ModuleLoader loader = new ModuleLoader(new ModuleRegister(new ModuleAutoFinder()));
        for (String filename : filenames) {
            HashSet<Module> modules = new HashSet<Module>();
            modules.addAll(loader.load(filename));
            Task task = taskClass.newInstance();
            task.init(modules);
            task.call();
        }
    }

    public Collection<File> addPlugins() {
        ArrayList<File> files = new ArrayList<File>();
        try {
            ArrayList<String> dirs = new ArrayList<String>();
            dirs.add("plugins");
            dirs.add("../plugins");
            URL url = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            URI uri = new URI(url.toString());
            File parent = new File(uri);
            while (parent.isFile()) {
                parent = parent.getParentFile();
            }
            for (String filename : dirs) {
                File plugins = new File(parent, filename);
                try {
                    if (!plugins.exists()) continue;
                    for (File jar : plugins.listFiles()) {
                        if (!jar.getName().endsWith(".jar")) continue;
                        ClassPath.addFile(jar);
                        files.add(jar);
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return files;
    }
}

