/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.config;

import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.opt4j.core.config.Task;
import org.opt4j.core.config.TaskListener;
import org.opt4j.core.config.TaskStateListener;

@Singleton
public class ExecutionEnvironment
implements TaskStateListener {
    protected final Provider<Task> taskProvider;
    protected final ExecutorService executor;
    protected final List<Task> tasks = new ArrayList<Task>();
    protected final Set<TaskListener> listeners = new CopyOnWriteArraySet<TaskListener>();

    @Inject
    public ExecutionEnvironment(Provider<Task> taskProvider) {
        this.taskProvider = taskProvider;
        this.executor = Executors.newFixedThreadPool(1);
    }

    public void execute(Collection<Module> modules) {
        final Task task = (Task)this.taskProvider.get();
        task.addStateListener(this);
        task.init(modules);
        this.addTask(task);
        Thread thread = new Thread(){

            @Override
            public void run() {
                Future<Void> future = ExecutionEnvironment.this.executor.submit(task);
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        };
        thread.start();
    }

    protected void addTask(Task task) {
        this.tasks.add(task);
        for (TaskListener listener : this.listeners) {
            listener.added(task);
        }
    }

    public void addListener(TaskListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TaskListener listener) {
        this.listeners.remove(listener);
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    @Override
    public void stateChanged(Task task) {
        for (TaskListener listener : this.listeners) {
            listener.stateChanged(task);
        }
    }
}

