package org.opfab.users.model;

import java.util.Objects;
import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
/**
 * UserActionLog
 */


@JsonInclude(JsonInclude.Include.NON_NULL)
public class UserActionLog   {
  private String login = null;

  
  private List<String> entities = null;

  private String action = null;

  private String cardUid = null;

  private String comment = null;

  public UserActionLog login(String login) {
    this.login = login;
    return this;
  }

  /**
   * Get login
   * @return login
  **/
  //@ApiModelProperty(value = "")
  public String getLogin() {
    return login;
  }

  public void setLogin(String login) {
    this.login = login;
  }

  public UserActionLog entities(List<String> entities) {
    this.entities = entities;
    return this;
  }

  public UserActionLog addEntitiesItem(String entitiesItem) {
    if (this.entities == null) {
      this.entities = new ArrayList<>();
    }
    this.entities.add(entitiesItem);
    return this;
  }

  /**
   * Get entities
   * @return entities
  **/
  //@ApiModelProperty(value = "")
  public List<String> getEntities() {
    return entities;
  }

  public void setEntities(List<String> entities) {
    this.entities = entities;
  }

  public UserActionLog action(String action) {
    this.action = action;
    return this;
  }

  /**
   * Get action
   * @return action
  **/
  //@ApiModelProperty(value = "")
  public String getAction() {
    return action;
  }

  public void setAction(String action) {
    this.action = action;
  }

  public UserActionLog cardUid(String cardUid) {
    this.cardUid = cardUid;
    return this;
  }

  /**
   * Get cardUid
   * @return cardUid
  **/
  //@ApiModelProperty(value = "")
  public String getCardUid() {
    return cardUid;
  }

  public void setCardUid(String cardUid) {
    this.cardUid = cardUid;
  }

  public UserActionLog comment(String comment) {
    this.comment = comment;
    return this;
  }

  /**
   * Get comment
   * @return comment
  **/
  //@ApiModelProperty(value = "")
  public String getComment() {
    return comment;
  }

  public void setComment(String comment) {
    this.comment = comment;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserActionLog userActionLog = (UserActionLog) o;
    return Objects.equals(this.login, userActionLog.login) &&
        Objects.equals(this.entities, userActionLog.entities) &&
        Objects.equals(this.action, userActionLog.action) &&
        Objects.equals(this.cardUid, userActionLog.cardUid) &&
        Objects.equals(this.comment, userActionLog.comment);
  }

  @Override
  public int hashCode() {
    return Objects.hash(login, entities, action, cardUid, comment);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserActionLog {\n");
    
    sb.append("    login: ").append(toIndentedString(login)).append("\n");
    sb.append("    entities: ").append(toIndentedString(entities)).append("\n");
    sb.append("    action: ").append(toIndentedString(action)).append("\n");
    sb.append("    cardUid: ").append(toIndentedString(cardUid)).append("\n");
    sb.append("    comment: ").append(toIndentedString(comment)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

