package org.opfab.users.model;

import java.util.Objects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opfab.users.model.ComputedPerimeter;
import org.opfab.users.model.User;

import com.fasterxml.jackson.annotation.JsonInclude;
/**
 * Information about the user connected and his perimeters
 */
//@ApiModel(description = "Information about the user connected and his perimeters")


@JsonInclude(JsonInclude.Include.NON_NULL)
public class CurrentUserWithPerimeters   {
  private User userData = null;

  
  private List<ComputedPerimeter> computedPerimeters = null;

  
  private Map<String, List<String>> processesStatesNotNotified = null;

  
  private Map<String, List<String>> processesStatesNotifiedByEmail = null;

  private Boolean sendCardsByEmail = null;

  private Boolean emailToPlainText = null;

  private String email = null;

  
  private List<org.opfab.users.model.PermissionEnum> permissions = null;

  public CurrentUserWithPerimeters userData(User userData) {
    this.userData = userData;
    return this;
  }

  /**
   * Get userData
   * @return userData
  **/
  //@ApiModelProperty(value = "")
  public User getUserData() {
    return userData;
  }

  public void setUserData(User userData) {
    this.userData = userData;
  }

  public CurrentUserWithPerimeters computedPerimeters(List<ComputedPerimeter> computedPerimeters) {
    this.computedPerimeters = computedPerimeters;
    return this;
  }

  public CurrentUserWithPerimeters addComputedPerimetersItem(ComputedPerimeter computedPerimetersItem) {
    if (this.computedPerimeters == null) {
      this.computedPerimeters = new ArrayList<>();
    }
    this.computedPerimeters.add(computedPerimetersItem);
    return this;
  }

  /**
   * Get computedPerimeters
   * @return computedPerimeters
  **/
  //@ApiModelProperty(value = "")
  public List<ComputedPerimeter> getComputedPerimeters() {
    return computedPerimeters;
  }

  public void setComputedPerimeters(List<ComputedPerimeter> computedPerimeters) {
    this.computedPerimeters = computedPerimeters;
  }

  public CurrentUserWithPerimeters processesStatesNotNotified(Map<String, List<String>> processesStatesNotNotified) {
    this.processesStatesNotNotified = processesStatesNotNotified;
    return this;
  }

  public CurrentUserWithPerimeters putProcessesStatesNotNotifiedItem(String key, List<String> processesStatesNotNotifiedItem) {
    if (this.processesStatesNotNotified == null) {
      this.processesStatesNotNotified = new HashMap<>();
    }
    this.processesStatesNotNotified.put(key, processesStatesNotNotifiedItem);
    return this;
  }

  /**
   * Filters on processes and states for user feed (exclusion filter)
   * @return processesStatesNotNotified
  **/
  //@ApiModelProperty(value = "Filters on processes and states for user feed (exclusion filter)")
  public Map<String, List<String>> getProcessesStatesNotNotified() {
    return processesStatesNotNotified;
  }

  public void setProcessesStatesNotNotified(Map<String, List<String>> processesStatesNotNotified) {
    this.processesStatesNotNotified = processesStatesNotNotified;
  }

  public CurrentUserWithPerimeters processesStatesNotifiedByEmail(Map<String, List<String>> processesStatesNotifiedByEmail) {
    this.processesStatesNotifiedByEmail = processesStatesNotifiedByEmail;
    return this;
  }

  public CurrentUserWithPerimeters putProcessesStatesNotifiedByEmailItem(String key, List<String> processesStatesNotifiedByEmailItem) {
    if (this.processesStatesNotifiedByEmail == null) {
      this.processesStatesNotifiedByEmail = new HashMap<>();
    }
    this.processesStatesNotifiedByEmail.put(key, processesStatesNotifiedByEmailItem);
    return this;
  }

  /**
   * Indicates for which process states the user will be notified by email
   * @return processesStatesNotifiedByEmail
  **/
  //@ApiModelProperty(value = "Indicates for which process states the user will be notified by email")
  public Map<String, List<String>> getProcessesStatesNotifiedByEmail() {
    return processesStatesNotifiedByEmail;
  }

  public void setProcessesStatesNotifiedByEmail(Map<String, List<String>> processesStatesNotifiedByEmail) {
    this.processesStatesNotifiedByEmail = processesStatesNotifiedByEmail;
  }

  public CurrentUserWithPerimeters sendCardsByEmail(Boolean sendCardsByEmail) {
    this.sendCardsByEmail = sendCardsByEmail;
    return this;
  }

  /**
   * If this is set to true, Opfab will send unread cards notification by email
   * @return sendCardsByEmail
  **/
  //@ApiModelProperty(value = "If this is set to true, Opfab will send unread cards notification by email")
  public Boolean getSendCardsByEmail() {
    return sendCardsByEmail;
  }

  public void setSendCardsByEmail(Boolean sendCardsByEmail) {
    this.sendCardsByEmail = sendCardsByEmail;
  }

  public CurrentUserWithPerimeters emailToPlainText(Boolean emailToPlainText) {
    this.emailToPlainText = emailToPlainText;
    return this;
  }

  /**
   * If this is set to true, the emails' bodies will be plain text
   * @return emailToPlainText
  **/
  //@ApiModelProperty(value = "If this is set to true, the emails' bodies will be plain text")
  public Boolean getEmailToPlainText() {
    return emailToPlainText;
  }

  public void setEmailToPlainText(Boolean emailToPlainText) {
    this.emailToPlainText = emailToPlainText;
  }

  public CurrentUserWithPerimeters email(String email) {
    this.email = email;
    return this;
  }

  /**
   * Email address to use as recipient for email notifications
   * @return email
  **/
  //@ApiModelProperty(value = "Email address to use as recipient for email notifications")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public CurrentUserWithPerimeters permissions(List<org.opfab.users.model.PermissionEnum> permissions) {
    this.permissions = permissions;
    return this;
  }

  public CurrentUserWithPerimeters addPermissionsItem(org.opfab.users.model.PermissionEnum permissionsItem) {
    if (this.permissions == null) {
      this.permissions = new ArrayList<>();
    }
    this.permissions.add(permissionsItem);
    return this;
  }

  /**
   * Get permissions
   * @return permissions
  **/
  //@ApiModelProperty(value = "")
  public List<org.opfab.users.model.PermissionEnum> getPermissions() {
    return permissions;
  }

  public void setPermissions(List<org.opfab.users.model.PermissionEnum> permissions) {
    this.permissions = permissions;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CurrentUserWithPerimeters currentUserWithPerimeters = (CurrentUserWithPerimeters) o;
    return Objects.equals(this.userData, currentUserWithPerimeters.userData) &&
        Objects.equals(this.computedPerimeters, currentUserWithPerimeters.computedPerimeters) &&
        Objects.equals(this.processesStatesNotNotified, currentUserWithPerimeters.processesStatesNotNotified) &&
        Objects.equals(this.processesStatesNotifiedByEmail, currentUserWithPerimeters.processesStatesNotifiedByEmail) &&
        Objects.equals(this.sendCardsByEmail, currentUserWithPerimeters.sendCardsByEmail) &&
        Objects.equals(this.emailToPlainText, currentUserWithPerimeters.emailToPlainText) &&
        Objects.equals(this.email, currentUserWithPerimeters.email) &&
        Objects.equals(this.permissions, currentUserWithPerimeters.permissions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userData, computedPerimeters, processesStatesNotNotified, processesStatesNotifiedByEmail, sendCardsByEmail, emailToPlainText, email, permissions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CurrentUserWithPerimeters {\n");
    
    sb.append("    userData: ").append(toIndentedString(userData)).append("\n");
    sb.append("    computedPerimeters: ").append(toIndentedString(computedPerimeters)).append("\n");
    sb.append("    processesStatesNotNotified: ").append(toIndentedString(processesStatesNotNotified)).append("\n");
    sb.append("    processesStatesNotifiedByEmail: ").append(toIndentedString(processesStatesNotifiedByEmail)).append("\n");
    sb.append("    sendCardsByEmail: ").append(toIndentedString(sendCardsByEmail)).append("\n");
    sb.append("    emailToPlainText: ").append(toIndentedString(emailToPlainText)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

