package org.opfab.users.model;

import java.util.Objects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonInclude;
/**
 * User associated settings. Note that the current supported locales are en and fr. Date and time formats use Moment.js formats.
 */
//@ApiModel(description = "User associated settings. Note that the current supported locales are en and fr. Date and time formats use Moment.js formats.")


@JsonInclude(JsonInclude.Include.NON_NULL)
public class UserSettings   {
  private String login = null;

  private String locale = null;

  private Boolean playSoundForAlarm = null;

  private Boolean playSoundForAction = null;

  private Boolean playSoundForCompliant = null;

  private Boolean playSoundForInformation = null;

  private Boolean systemNotificationAlarm = null;

  private Boolean systemNotificationAction = null;

  private Boolean systemNotificationCompliant = null;

  private Boolean systemNotificationInformation = null;

  private Boolean playSoundOnExternalDevice = null;

  private Boolean replayEnabled = null;

  private Integer replayInterval = null;

  private Boolean remoteLoggingEnabled = null;

  
  private Map<String, List<String>> processesStatesNotNotified = null;

  
  private Map<String, List<String>> processesStatesNotifiedByEmail = null;

  
  private List<String> entitiesDisconnected = null;

  private Boolean sendCardsByEmail = null;

  private String email = null;

  public UserSettings login(String login) {
    this.login = login;
    return this;
  }

  /**
   * User login
   * @return login
  **/
  //@ApiModelProperty(required = true, value = "User login")
  public String getLogin() {
    return login;
  }

  public void setLogin(String login) {
    this.login = login;
  }

  public UserSettings locale(String locale) {
    this.locale = locale;
    return this;
  }

  /**
   * User using browser format
   * @return locale
  **/
  //@ApiModelProperty(value = "User using browser format")
  public String getLocale() {
    return locale;
  }

  public void setLocale(String locale) {
    this.locale = locale;
  }

  public UserSettings playSoundForAlarm(Boolean playSoundForAlarm) {
    this.playSoundForAlarm = playSoundForAlarm;
    return this;
  }

  /**
   * If this is set to true, a sound will be played for incoming cards with ALARM severity.
   * @return playSoundForAlarm
  **/
  //@ApiModelProperty(value = "If this is set to true, a sound will be played for incoming cards with ALARM severity.")
  public Boolean getPlaySoundForAlarm() {
    return playSoundForAlarm;
  }

  public void setPlaySoundForAlarm(Boolean playSoundForAlarm) {
    this.playSoundForAlarm = playSoundForAlarm;
  }

  public UserSettings playSoundForAction(Boolean playSoundForAction) {
    this.playSoundForAction = playSoundForAction;
    return this;
  }

  /**
   * If this is set to true, a sound will be played for incoming cards with ACTION severity.
   * @return playSoundForAction
  **/
  //@ApiModelProperty(value = "If this is set to true, a sound will be played for incoming cards with ACTION severity.")
  public Boolean getPlaySoundForAction() {
    return playSoundForAction;
  }

  public void setPlaySoundForAction(Boolean playSoundForAction) {
    this.playSoundForAction = playSoundForAction;
  }

  public UserSettings playSoundForCompliant(Boolean playSoundForCompliant) {
    this.playSoundForCompliant = playSoundForCompliant;
    return this;
  }

  /**
   * If this is set to true, a sound will be played for incoming cards with COMPLIANT severity.
   * @return playSoundForCompliant
  **/
  //@ApiModelProperty(value = "If this is set to true, a sound will be played for incoming cards with COMPLIANT severity.")
  public Boolean getPlaySoundForCompliant() {
    return playSoundForCompliant;
  }

  public void setPlaySoundForCompliant(Boolean playSoundForCompliant) {
    this.playSoundForCompliant = playSoundForCompliant;
  }

  public UserSettings playSoundForInformation(Boolean playSoundForInformation) {
    this.playSoundForInformation = playSoundForInformation;
    return this;
  }

  /**
   * If this is set to true, a sound will be played for incoming cards with INFORMATION severity.
   * @return playSoundForInformation
  **/
  //@ApiModelProperty(value = "If this is set to true, a sound will be played for incoming cards with INFORMATION severity.")
  public Boolean getPlaySoundForInformation() {
    return playSoundForInformation;
  }

  public void setPlaySoundForInformation(Boolean playSoundForInformation) {
    this.playSoundForInformation = playSoundForInformation;
  }

  public UserSettings systemNotificationAlarm(Boolean systemNotificationAlarm) {
    this.systemNotificationAlarm = systemNotificationAlarm;
    return this;
  }

  /**
   * If this is set to true, a notification will be sent for incoming cards with ALARM severity.
   * @return systemNotificationAlarm
  **/
  //@ApiModelProperty(value = "If this is set to true, a notification will be sent for incoming cards with ALARM severity.")
  public Boolean getSystemNotificationAlarm() {
    return systemNotificationAlarm;
  }

  public void setSystemNotificationAlarm(Boolean systemNotificationAlarm) {
    this.systemNotificationAlarm = systemNotificationAlarm;
  }

  public UserSettings systemNotificationAction(Boolean systemNotificationAction) {
    this.systemNotificationAction = systemNotificationAction;
    return this;
  }

  /**
   * If this is set to true, a notification will be sent for incoming cards with ACTION severity.
   * @return systemNotificationAction
  **/
  //@ApiModelProperty(value = "If this is set to true, a notification will be sent for incoming cards with ACTION severity.")
  public Boolean getSystemNotificationAction() {
    return systemNotificationAction;
  }

  public void setSystemNotificationAction(Boolean systemNotificationAction) {
    this.systemNotificationAction = systemNotificationAction;
  }

  public UserSettings systemNotificationCompliant(Boolean systemNotificationCompliant) {
    this.systemNotificationCompliant = systemNotificationCompliant;
    return this;
  }

  /**
   * If this is set to true, a notification will be sent for incoming cards with COMPLIANT severity.
   * @return systemNotificationCompliant
  **/
  //@ApiModelProperty(value = "If this is set to true, a notification will be sent for incoming cards with COMPLIANT severity.")
  public Boolean getSystemNotificationCompliant() {
    return systemNotificationCompliant;
  }

  public void setSystemNotificationCompliant(Boolean systemNotificationCompliant) {
    this.systemNotificationCompliant = systemNotificationCompliant;
  }

  public UserSettings systemNotificationInformation(Boolean systemNotificationInformation) {
    this.systemNotificationInformation = systemNotificationInformation;
    return this;
  }

  /**
   * If this is set to true, a notification will be sent for incoming cards with INFORMATION severity.
   * @return systemNotificationInformation
  **/
  //@ApiModelProperty(value = "If this is set to true, a notification will be sent for incoming cards with INFORMATION severity.")
  public Boolean getSystemNotificationInformation() {
    return systemNotificationInformation;
  }

  public void setSystemNotificationInformation(Boolean systemNotificationInformation) {
    this.systemNotificationInformation = systemNotificationInformation;
  }

  public UserSettings playSoundOnExternalDevice(Boolean playSoundOnExternalDevice) {
    this.playSoundOnExternalDevice = playSoundOnExternalDevice;
    return this;
  }

  /**
   * If set to true and the user has an external device configured, sounds will be played on this device rather than in the browser
   * @return playSoundOnExternalDevice
  **/
  //@ApiModelProperty(value = "If set to true and the user has an external device configured, sounds will be played on this device rather than in the browser")
  public Boolean getPlaySoundOnExternalDevice() {
    return playSoundOnExternalDevice;
  }

  public void setPlaySoundOnExternalDevice(Boolean playSoundOnExternalDevice) {
    this.playSoundOnExternalDevice = playSoundOnExternalDevice;
  }

  public UserSettings replayEnabled(Boolean replayEnabled) {
    this.replayEnabled = replayEnabled;
    return this;
  }

  /**
   * If this is set to true, sounds for incoming cards or reminders will be replayed until the user clicks anywhere on the screen.
   * @return replayEnabled
  **/
  //@ApiModelProperty(value = "If this is set to true, sounds for incoming cards or reminders will be replayed until the user clicks anywhere on the screen.")
  public Boolean getReplayEnabled() {
    return replayEnabled;
  }

  public void setReplayEnabled(Boolean replayEnabled) {
    this.replayEnabled = replayEnabled;
  }

  public UserSettings replayInterval(Integer replayInterval) {
    this.replayInterval = replayInterval;
    return this;
  }

  /**
   * Interval (in seconds) between sound replays.
   * @return replayInterval
  **/
  //@ApiModelProperty(value = "Interval (in seconds) between sound replays.")
  public Integer getReplayInterval() {
    return replayInterval;
  }

  public void setReplayInterval(Integer replayInterval) {
    this.replayInterval = replayInterval;
  }

  public UserSettings remoteLoggingEnabled(Boolean remoteLoggingEnabled) {
    this.remoteLoggingEnabled = remoteLoggingEnabled;
    return this;
  }

  /**
   * If this is set to true, some of the ui logs are stored in the log file of cards-consultation service 
   * @return remoteLoggingEnabled
  **/
  //@ApiModelProperty(value = "If this is set to true, some of the ui logs are stored in the log file of cards-consultation service ")
  public Boolean getRemoteLoggingEnabled() {
    return remoteLoggingEnabled;
  }

  public void setRemoteLoggingEnabled(Boolean remoteLoggingEnabled) {
    this.remoteLoggingEnabled = remoteLoggingEnabled;
  }

  public UserSettings processesStatesNotNotified(Map<String, List<String>> processesStatesNotNotified) {
    this.processesStatesNotNotified = processesStatesNotNotified;
    return this;
  }

  public UserSettings putProcessesStatesNotNotifiedItem(String key, List<String> processesStatesNotNotifiedItem) {
    if (this.processesStatesNotNotified == null) {
      this.processesStatesNotNotified = new HashMap<>();
    }
    this.processesStatesNotNotified.put(key, processesStatesNotNotifiedItem);
    return this;
  }

  /**
   * Filters on processes and states for user feed (exclusion filter)
   * @return processesStatesNotNotified
  **/
  //@ApiModelProperty(value = "Filters on processes and states for user feed (exclusion filter)")
  public Map<String, List<String>> getProcessesStatesNotNotified() {
    return processesStatesNotNotified;
  }

  public void setProcessesStatesNotNotified(Map<String, List<String>> processesStatesNotNotified) {
    this.processesStatesNotNotified = processesStatesNotNotified;
  }

  public UserSettings processesStatesNotifiedByEmail(Map<String, List<String>> processesStatesNotifiedByEmail) {
    this.processesStatesNotifiedByEmail = processesStatesNotifiedByEmail;
    return this;
  }

  public UserSettings putProcessesStatesNotifiedByEmailItem(String key, List<String> processesStatesNotifiedByEmailItem) {
    if (this.processesStatesNotifiedByEmail == null) {
      this.processesStatesNotifiedByEmail = new HashMap<>();
    }
    this.processesStatesNotifiedByEmail.put(key, processesStatesNotifiedByEmailItem);
    return this;
  }

  /**
   * Indicates for which process states the user will be notified by email
   * @return processesStatesNotifiedByEmail
  **/
  //@ApiModelProperty(value = "Indicates for which process states the user will be notified by email")
  public Map<String, List<String>> getProcessesStatesNotifiedByEmail() {
    return processesStatesNotifiedByEmail;
  }

  public void setProcessesStatesNotifiedByEmail(Map<String, List<String>> processesStatesNotifiedByEmail) {
    this.processesStatesNotifiedByEmail = processesStatesNotifiedByEmail;
  }

  public UserSettings entitiesDisconnected(List<String> entitiesDisconnected) {
    this.entitiesDisconnected = entitiesDisconnected;
    return this;
  }

  public UserSettings addEntitiesDisconnectedItem(String entitiesDisconnectedItem) {
    if (this.entitiesDisconnected == null) {
      this.entitiesDisconnected = new ArrayList<>();
    }
    this.entitiesDisconnected.add(entitiesDisconnectedItem);
    return this;
  }

  /**
   * Entities not represented by the user for his current session
   * @return entitiesDisconnected
  **/
  //@ApiModelProperty(value = "Entities not represented by the user for his current session")
  public List<String> getEntitiesDisconnected() {
    return entitiesDisconnected;
  }

  public void setEntitiesDisconnected(List<String> entitiesDisconnected) {
    this.entitiesDisconnected = entitiesDisconnected;
  }

  public UserSettings sendCardsByEmail(Boolean sendCardsByEmail) {
    this.sendCardsByEmail = sendCardsByEmail;
    return this;
  }

  /**
   * If this is set to true, Opfab will send unread cards notification by email
   * @return sendCardsByEmail
  **/
  //@ApiModelProperty(value = "If this is set to true, Opfab will send unread cards notification by email")
  public Boolean getSendCardsByEmail() {
    return sendCardsByEmail;
  }

  public void setSendCardsByEmail(Boolean sendCardsByEmail) {
    this.sendCardsByEmail = sendCardsByEmail;
  }

  public UserSettings email(String email) {
    this.email = email;
    return this;
  }

  /**
   * Email address to use as recipient for email notifications
   * @return email
  **/
  //@ApiModelProperty(value = "Email address to use as recipient for email notifications")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserSettings userSettings = (UserSettings) o;
    return Objects.equals(this.login, userSettings.login) &&
        Objects.equals(this.locale, userSettings.locale) &&
        Objects.equals(this.playSoundForAlarm, userSettings.playSoundForAlarm) &&
        Objects.equals(this.playSoundForAction, userSettings.playSoundForAction) &&
        Objects.equals(this.playSoundForCompliant, userSettings.playSoundForCompliant) &&
        Objects.equals(this.playSoundForInformation, userSettings.playSoundForInformation) &&
        Objects.equals(this.systemNotificationAlarm, userSettings.systemNotificationAlarm) &&
        Objects.equals(this.systemNotificationAction, userSettings.systemNotificationAction) &&
        Objects.equals(this.systemNotificationCompliant, userSettings.systemNotificationCompliant) &&
        Objects.equals(this.systemNotificationInformation, userSettings.systemNotificationInformation) &&
        Objects.equals(this.playSoundOnExternalDevice, userSettings.playSoundOnExternalDevice) &&
        Objects.equals(this.replayEnabled, userSettings.replayEnabled) &&
        Objects.equals(this.replayInterval, userSettings.replayInterval) &&
        Objects.equals(this.remoteLoggingEnabled, userSettings.remoteLoggingEnabled) &&
        Objects.equals(this.processesStatesNotNotified, userSettings.processesStatesNotNotified) &&
        Objects.equals(this.processesStatesNotifiedByEmail, userSettings.processesStatesNotifiedByEmail) &&
        Objects.equals(this.entitiesDisconnected, userSettings.entitiesDisconnected) &&
        Objects.equals(this.sendCardsByEmail, userSettings.sendCardsByEmail) &&
        Objects.equals(this.email, userSettings.email);
  }

  @Override
  public int hashCode() {
    return Objects.hash(login, locale, playSoundForAlarm, playSoundForAction, playSoundForCompliant, playSoundForInformation, systemNotificationAlarm, systemNotificationAction, systemNotificationCompliant, systemNotificationInformation, playSoundOnExternalDevice, replayEnabled, replayInterval, remoteLoggingEnabled, processesStatesNotNotified, processesStatesNotifiedByEmail, entitiesDisconnected, sendCardsByEmail, email);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserSettings {\n");
    
    sb.append("    login: ").append(toIndentedString(login)).append("\n");
    sb.append("    locale: ").append(toIndentedString(locale)).append("\n");
    sb.append("    playSoundForAlarm: ").append(toIndentedString(playSoundForAlarm)).append("\n");
    sb.append("    playSoundForAction: ").append(toIndentedString(playSoundForAction)).append("\n");
    sb.append("    playSoundForCompliant: ").append(toIndentedString(playSoundForCompliant)).append("\n");
    sb.append("    playSoundForInformation: ").append(toIndentedString(playSoundForInformation)).append("\n");
    sb.append("    systemNotificationAlarm: ").append(toIndentedString(systemNotificationAlarm)).append("\n");
    sb.append("    systemNotificationAction: ").append(toIndentedString(systemNotificationAction)).append("\n");
    sb.append("    systemNotificationCompliant: ").append(toIndentedString(systemNotificationCompliant)).append("\n");
    sb.append("    systemNotificationInformation: ").append(toIndentedString(systemNotificationInformation)).append("\n");
    sb.append("    playSoundOnExternalDevice: ").append(toIndentedString(playSoundOnExternalDevice)).append("\n");
    sb.append("    replayEnabled: ").append(toIndentedString(replayEnabled)).append("\n");
    sb.append("    replayInterval: ").append(toIndentedString(replayInterval)).append("\n");
    sb.append("    remoteLoggingEnabled: ").append(toIndentedString(remoteLoggingEnabled)).append("\n");
    sb.append("    processesStatesNotNotified: ").append(toIndentedString(processesStatesNotNotified)).append("\n");
    sb.append("    processesStatesNotifiedByEmail: ").append(toIndentedString(processesStatesNotifiedByEmail)).append("\n");
    sb.append("    entitiesDisconnected: ").append(toIndentedString(entitiesDisconnected)).append("\n");
    sb.append("    sendCardsByEmail: ").append(toIndentedString(sendCardsByEmail)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

