package org.opfab.users.model;

import java.util.Objects;
import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
/**
 * Group
 */


@JsonInclude(JsonInclude.Include.NON_NULL)
public class Group   {
  private String id = null;

  private String name = null;

  private String description = null;

  
  private List<String> perimeters = null;

  
  private List<org.opfab.users.model.PermissionEnum> permissions = null;

  private Boolean realtime = null;

  public Group id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Id must be minimum 2 characters and must only contain letters, _, - or digits.
   * @return id
  **/
  //@ApiModelProperty(required = true, value = "Id must be minimum 2 characters and must only contain letters, _, - or digits.")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Group name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  **/
  //@ApiModelProperty(value = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Group description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  **/
  //@ApiModelProperty(value = "")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Group perimeters(List<String> perimeters) {
    this.perimeters = perimeters;
    return this;
  }

  public Group addPerimetersItem(String perimetersItem) {
    if (this.perimeters == null) {
      this.perimeters = new ArrayList<>();
    }
    this.perimeters.add(perimetersItem);
    return this;
  }

  /**
   * Get perimeters
   * @return perimeters
  **/
  //@ApiModelProperty(value = "")
  public List<String> getPerimeters() {
    return perimeters;
  }

  public void setPerimeters(List<String> perimeters) {
    this.perimeters = perimeters;
  }

  public Group permissions(List<org.opfab.users.model.PermissionEnum> permissions) {
    this.permissions = permissions;
    return this;
  }

  public Group addPermissionsItem(org.opfab.users.model.PermissionEnum permissionsItem) {
    if (this.permissions == null) {
      this.permissions = new ArrayList<>();
    }
    this.permissions.add(permissionsItem);
    return this;
  }

  /**
   * Get permissions
   * @return permissions
  **/
  //@ApiModelProperty(value = "")
  public List<org.opfab.users.model.PermissionEnum> getPermissions() {
    return permissions;
  }

  public void setPermissions(List<org.opfab.users.model.PermissionEnum> permissions) {
    this.permissions = permissions;
  }

  public Group realtime(Boolean realtime) {
    this.realtime = realtime;
    return this;
  }

  /**
   * Get realtime
   * @return realtime
  **/
  //@ApiModelProperty(value = "")
  public Boolean getRealtime() {
    return realtime;
  }

  public void setRealtime(Boolean realtime) {
    this.realtime = realtime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Group group = (Group) o;
    return Objects.equals(this.id, group.id) &&
        Objects.equals(this.name, group.name) &&
        Objects.equals(this.description, group.description) &&
        Objects.equals(this.perimeters, group.perimeters) &&
        Objects.equals(this.permissions, group.permissions) &&
        Objects.equals(this.realtime, group.realtime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, description, perimeters, permissions, realtime);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Group {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    perimeters: ").append(toIndentedString(perimeters)).append("\n");
    sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
    sb.append("    realtime: ").append(toIndentedString(realtime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

