package org.opfab.cards.model;

import java.util.Objects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.opfab.cards.model.FilterModel;

import com.fasterxml.jackson.annotation.JsonInclude;
/**
 * CardsFilter
 */


@JsonInclude(JsonInclude.Include.NON_NULL)
public class CardsFilter   {
  private BigDecimal page = null;

  private BigDecimal size = null;

  private Boolean adminMode = null;

  private Boolean includeChildCards = null;

  private Boolean latestUpdateOnly = null;

  
  private List<FilterModel> filters = null;

  
  private List<String> selectedFields = null;

  public CardsFilter page(BigDecimal page) {
    this.page = page;
    return this;
  }

  /**
   * Page number
   * @return page
  **/
  //@ApiModelProperty(value = "Page number")
  public BigDecimal getPage() {
    return page;
  }

  public void setPage(BigDecimal page) {
    this.page = page;
  }

  public CardsFilter size(BigDecimal size) {
    this.size = size;
    return this;
  }

  /**
   * Page size (max number of items in page)
   * @return size
  **/
  //@ApiModelProperty(value = "Page size (max number of items in page)")
  public BigDecimal getSize() {
    return size;
  }

  public void setSize(BigDecimal size) {
    this.size = size;
  }

  public CardsFilter adminMode(Boolean adminMode) {
    this.adminMode = adminMode;
    return this;
  }

  /**
   * Get adminMode
   * @return adminMode
  **/
  //@ApiModelProperty(value = "")
  public Boolean getAdminMode() {
    return adminMode;
  }

  public void setAdminMode(Boolean adminMode) {
    this.adminMode = adminMode;
  }

  public CardsFilter includeChildCards(Boolean includeChildCards) {
    this.includeChildCards = includeChildCards;
    return this;
  }

  /**
   * Get includeChildCards
   * @return includeChildCards
  **/
  //@ApiModelProperty(value = "")
  public Boolean getIncludeChildCards() {
    return includeChildCards;
  }

  public void setIncludeChildCards(Boolean includeChildCards) {
    this.includeChildCards = includeChildCards;
  }

  public CardsFilter latestUpdateOnly(Boolean latestUpdateOnly) {
    this.latestUpdateOnly = latestUpdateOnly;
    return this;
  }

  /**
   * Get latestUpdateOnly
   * @return latestUpdateOnly
  **/
  //@ApiModelProperty(value = "")
  public Boolean getLatestUpdateOnly() {
    return latestUpdateOnly;
  }

  public void setLatestUpdateOnly(Boolean latestUpdateOnly) {
    this.latestUpdateOnly = latestUpdateOnly;
  }

  public CardsFilter filters(List<FilterModel> filters) {
    this.filters = filters;
    return this;
  }

  public CardsFilter addFiltersItem(FilterModel filtersItem) {
    if (this.filters == null) {
      this.filters = new ArrayList<>();
    }
    this.filters.add(filtersItem);
    return this;
  }

  /**
   * Get filters
   * @return filters
  **/
  //@ApiModelProperty(value = "")
  public List<FilterModel> getFilters() {
    return filters;
  }

  public void setFilters(List<FilterModel> filters) {
    this.filters = filters;
  }

  public CardsFilter selectedFields(List<String> selectedFields) {
    this.selectedFields = selectedFields;
    return this;
  }

  public CardsFilter addSelectedFieldsItem(String selectedFieldsItem) {
    if (this.selectedFields == null) {
      this.selectedFields = new ArrayList<>();
    }
    this.selectedFields.add(selectedFieldsItem);
    return this;
  }

  /**
   * Get selectedFields
   * @return selectedFields
  **/
  //@ApiModelProperty(value = "")
  public List<String> getSelectedFields() {
    return selectedFields;
  }

  public void setSelectedFields(List<String> selectedFields) {
    this.selectedFields = selectedFields;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CardsFilter cardsFilter = (CardsFilter) o;
    return Objects.equals(this.page, cardsFilter.page) &&
        Objects.equals(this.size, cardsFilter.size) &&
        Objects.equals(this.adminMode, cardsFilter.adminMode) &&
        Objects.equals(this.includeChildCards, cardsFilter.includeChildCards) &&
        Objects.equals(this.latestUpdateOnly, cardsFilter.latestUpdateOnly) &&
        Objects.equals(this.filters, cardsFilter.filters) &&
        Objects.equals(this.selectedFields, cardsFilter.selectedFields);
  }

  @Override
  public int hashCode() {
    return Objects.hash(page, size, adminMode, includeChildCards, latestUpdateOnly, filters, selectedFields);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CardsFilter {\n");
    
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    adminMode: ").append(toIndentedString(adminMode)).append("\n");
    sb.append("    includeChildCards: ").append(toIndentedString(includeChildCards)).append("\n");
    sb.append("    latestUpdateOnly: ").append(toIndentedString(latestUpdateOnly)).append("\n");
    sb.append("    filters: ").append(toIndentedString(filters)).append("\n");
    sb.append("    selectedFields: ").append(toIndentedString(selectedFields)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

