package org.opfab.cards.model;

import java.util.Objects;
import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
/**
 * Object representing a user connection (subscription)
 */
//@ApiModel(description = "Object representing a user connection (subscription)")


@JsonInclude(JsonInclude.Include.NON_NULL)
public class Connection   {
  private String login = null;

  
  private List<String> entitiesConnected = null;

  
  private List<String> groups = null;

  public Connection login(String login) {
    this.login = login;
    return this;
  }

  /**
   * Login of user
   * @return login
  **/
  //@ApiModelProperty(value = "Login of user")
  public String getLogin() {
    return login;
  }

  public void setLogin(String login) {
    this.login = login;
  }

  public Connection entitiesConnected(List<String> entitiesConnected) {
    this.entitiesConnected = entitiesConnected;
    return this;
  }

  public Connection addEntitiesConnectedItem(String entitiesConnectedItem) {
    if (this.entitiesConnected == null) {
      this.entitiesConnected = new ArrayList<>();
    }
    this.entitiesConnected.add(entitiesConnectedItem);
    return this;
  }

  /**
   * Get entitiesConnected
   * @return entitiesConnected
  **/
  //@ApiModelProperty(value = "")
  public List<String> getEntitiesConnected() {
    return entitiesConnected;
  }

  public void setEntitiesConnected(List<String> entitiesConnected) {
    this.entitiesConnected = entitiesConnected;
  }

  public Connection groups(List<String> groups) {
    this.groups = groups;
    return this;
  }

  public Connection addGroupsItem(String groupsItem) {
    if (this.groups == null) {
      this.groups = new ArrayList<>();
    }
    this.groups.add(groupsItem);
    return this;
  }

  /**
   * Get groups
   * @return groups
  **/
  //@ApiModelProperty(value = "")
  public List<String> getGroups() {
    return groups;
  }

  public void setGroups(List<String> groups) {
    this.groups = groups;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Connection connection = (Connection) o;
    return Objects.equals(this.login, connection.login) &&
        Objects.equals(this.entitiesConnected, connection.entitiesConnected) &&
        Objects.equals(this.groups, connection.groups);
  }

  @Override
  public int hashCode() {
    return Objects.hash(login, entitiesConnected, groups);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Connection {\n");
    
    sb.append("    login: ").append(toIndentedString(login)).append("\n");
    sb.append("    entitiesConnected: ").append(toIndentedString(entitiesConnected)).append("\n");
    sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

