package org.opfab.cards.model;

import java.util.Objects;
import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
/**
 * An object representing the recurrence of the card (as defined in the RFC 5545)
 */
//@ApiModel(description = "An object representing the recurrence of the card (as defined in the RFC 5545)")


@JsonInclude(JsonInclude.Include.NON_NULL)
public class RRule   {
  private org.opfab.cards.model.FreqEnum freq = null;

  private Integer interval = null;

  private Integer count = null;

  private org.opfab.cards.model.DayEnum wkst = null;

  
  private List<org.opfab.cards.model.DayEnum> byweekday = null;

  
  private List<Integer> bymonth = null;

  
  private List<Integer> byhour = null;

  
  private List<Integer> byminute = null;

  
  private List<Integer> bysetpos = null;

  
  private List<Integer> bymonthday = null;

  private String tzid = null;

  public RRule freq(org.opfab.cards.model.FreqEnum freq) {
    this.freq = freq;
    return this;
  }

  /**
   * Frequency of the recurrence
   * @return freq
  **/
  //@ApiModelProperty(value = "Frequency of the recurrence")
  public org.opfab.cards.model.FreqEnum getFreq() {
    return freq;
  }

  public void setFreq(org.opfab.cards.model.FreqEnum freq) {
    this.freq = freq;
  }

  public RRule interval(Integer interval) {
    this.interval = interval;
    return this;
  }

  /**
   * Represents at which intervals the recurrence rule repeats. The default value is \"1\", meaning every second for a SECONDLY rule, every minute for a MINUTELY rule etc.
   * @return interval
  **/
  //@ApiModelProperty(value = "Represents at which intervals the recurrence rule repeats. The default value is \"1\", meaning every second for a SECONDLY rule, every minute for a MINUTELY rule etc.")
  public Integer getInterval() {
    return interval;
  }

  public void setInterval(Integer interval) {
    this.interval = interval;
  }

  public RRule count(Integer count) {
    this.count = count;
    return this;
  }

  /**
   * Defines the number of occurrences at which to range-bound the recurrence
   * @return count
  **/
  //@ApiModelProperty(value = "Defines the number of occurrences at which to range-bound the recurrence")
  public Integer getCount() {
    return count;
  }

  public void setCount(Integer count) {
    this.count = count;
  }

  public RRule wkst(org.opfab.cards.model.DayEnum wkst) {
    this.wkst = wkst;
    return this;
  }

  /**
   * Defines the day on which the workweek starts. Valid values are MO, TU, WE, TH, FR, SA, and SU.
   * @return wkst
  **/
  //@ApiModelProperty(value = "Defines the day on which the workweek starts. Valid values are MO, TU, WE, TH, FR, SA, and SU.")
  public org.opfab.cards.model.DayEnum getWkst() {
    return wkst;
  }

  public void setWkst(org.opfab.cards.model.DayEnum wkst) {
    this.wkst = wkst;
  }

  public RRule byweekday(List<org.opfab.cards.model.DayEnum> byweekday) {
    this.byweekday = byweekday;
    return this;
  }

  public RRule addByweekdayItem(org.opfab.cards.model.DayEnum byweekdayItem) {
    if (this.byweekday == null) {
      this.byweekday = new ArrayList<>();
    }
    this.byweekday.add(byweekdayItem);
    return this;
  }

  /**
   * Defines a list of days of the week for the recurrence
   * @return byweekday
  **/
  //@ApiModelProperty(value = "Defines a list of days of the week for the recurrence")
  public List<org.opfab.cards.model.DayEnum> getByweekday() {
    return byweekday;
  }

  public void setByweekday(List<org.opfab.cards.model.DayEnum> byweekday) {
    this.byweekday = byweekday;
  }

  public RRule bymonth(List<Integer> bymonth) {
    this.bymonth = bymonth;
    return this;
  }

  public RRule addBymonthItem(Integer bymonthItem) {
    if (this.bymonth == null) {
      this.bymonth = new ArrayList<>();
    }
    this.bymonth.add(bymonthItem);
    return this;
  }

  /**
   * Defines a list of months of the year for the recurrence (from 1 to 12, 1 representing January)
   * @return bymonth
  **/
  //@ApiModelProperty(value = "Defines a list of months of the year for the recurrence (from 1 to 12, 1 representing January)")
  public List<Integer> getBymonth() {
    return bymonth;
  }

  public void setBymonth(List<Integer> bymonth) {
    this.bymonth = bymonth;
  }

  public RRule byhour(List<Integer> byhour) {
    this.byhour = byhour;
    return this;
  }

  public RRule addByhourItem(Integer byhourItem) {
    if (this.byhour == null) {
      this.byhour = new ArrayList<>();
    }
    this.byhour.add(byhourItem);
    return this;
  }

  /**
   * Defines a list of hours of the day for the recurrence (from 0 to 23)
   * @return byhour
  **/
  //@ApiModelProperty(value = "Defines a list of hours of the day for the recurrence (from 0 to 23)")
  public List<Integer> getByhour() {
    return byhour;
  }

  public void setByhour(List<Integer> byhour) {
    this.byhour = byhour;
  }

  public RRule byminute(List<Integer> byminute) {
    this.byminute = byminute;
    return this;
  }

  public RRule addByminuteItem(Integer byminuteItem) {
    if (this.byminute == null) {
      this.byminute = new ArrayList<>();
    }
    this.byminute.add(byminuteItem);
    return this;
  }

  /**
   * Defines a list of minutes within an hour for the recurrence (from 0 to 59)
   * @return byminute
  **/
  //@ApiModelProperty(value = "Defines a list of minutes within an hour for the recurrence (from 0 to 59)")
  public List<Integer> getByminute() {
    return byminute;
  }

  public void setByminute(List<Integer> byminute) {
    this.byminute = byminute;
  }

  public RRule bysetpos(List<Integer> bysetpos) {
    this.bysetpos = bysetpos;
    return this;
  }

  public RRule addBysetposItem(Integer bysetposItem) {
    if (this.bysetpos == null) {
      this.bysetpos = new ArrayList<>();
    }
    this.bysetpos.add(bysetposItem);
    return this;
  }

  /**
   * Array of integers, positive or negative. Each given integer will specify an occurrence number, corresponding to the nth occurrence of the rule inside the frequency period
   * @return bysetpos
  **/
  //@ApiModelProperty(value = "Array of integers, positive or negative. Each given integer will specify an occurrence number, corresponding to the nth occurrence of the rule inside the frequency period")
  public List<Integer> getBysetpos() {
    return bysetpos;
  }

  public void setBysetpos(List<Integer> bysetpos) {
    this.bysetpos = bysetpos;
  }

  public RRule bymonthday(List<Integer> bymonthday) {
    this.bymonthday = bymonthday;
    return this;
  }

  public RRule addBymonthdayItem(Integer bymonthdayItem) {
    if (this.bymonthday == null) {
      this.bymonthday = new ArrayList<>();
    }
    this.bymonthday.add(bymonthdayItem);
    return this;
  }

  /**
   * Defines the month days to apply the recurrence to
   * @return bymonthday
  **/
  //@ApiModelProperty(value = "Defines the month days to apply the recurrence to")
  public List<Integer> getBymonthday() {
    return bymonthday;
  }

  public void setBymonthday(List<Integer> bymonthday) {
    this.bymonthday = bymonthday;
  }

  public RRule tzid(String tzid) {
    this.tzid = tzid;
    return this;
  }

  /**
   * Time zone identifier (for example 'Europe/Paris', 'Europe/London', ...)
   * @return tzid
  **/
  //@ApiModelProperty(value = "Time zone identifier (for example 'Europe/Paris', 'Europe/London', ...)")
  public String getTzid() {
    return tzid;
  }

  public void setTzid(String tzid) {
    this.tzid = tzid;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RRule rrule = (RRule) o;
    return Objects.equals(this.freq, rrule.freq) &&
        Objects.equals(this.interval, rrule.interval) &&
        Objects.equals(this.count, rrule.count) &&
        Objects.equals(this.wkst, rrule.wkst) &&
        Objects.equals(this.byweekday, rrule.byweekday) &&
        Objects.equals(this.bymonth, rrule.bymonth) &&
        Objects.equals(this.byhour, rrule.byhour) &&
        Objects.equals(this.byminute, rrule.byminute) &&
        Objects.equals(this.bysetpos, rrule.bysetpos) &&
        Objects.equals(this.bymonthday, rrule.bymonthday) &&
        Objects.equals(this.tzid, rrule.tzid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(freq, interval, count, wkst, byweekday, bymonth, byhour, byminute, bysetpos, bymonthday, tzid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RRule {\n");
    
    sb.append("    freq: ").append(toIndentedString(freq)).append("\n");
    sb.append("    interval: ").append(toIndentedString(interval)).append("\n");
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    wkst: ").append(toIndentedString(wkst)).append("\n");
    sb.append("    byweekday: ").append(toIndentedString(byweekday)).append("\n");
    sb.append("    bymonth: ").append(toIndentedString(bymonth)).append("\n");
    sb.append("    byhour: ").append(toIndentedString(byhour)).append("\n");
    sb.append("    byminute: ").append(toIndentedString(byminute)).append("\n");
    sb.append("    bysetpos: ").append(toIndentedString(bysetpos)).append("\n");
    sb.append("    bymonthday: ").append(toIndentedString(bymonthday)).append("\n");
    sb.append("    tzid: ").append(toIndentedString(tzid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

