package org.opfab.cards.model;

import java.util.Objects;
import org.opfab.cards.model.I18n;

import com.fasterxml.jackson.annotation.JsonInclude;
/**
 * Card field to translate with i18n value
 */
//@ApiModel(description = "Card field to translate with i18n value")


@JsonInclude(JsonInclude.Include.NON_NULL)
public class FieldToTranslate   {
  private I18n i18nValue = null;

  private String process = null;

  private String processVersion = null;

  public FieldToTranslate i18nValue(I18n i18nValue) {
    this.i18nValue = i18nValue;
    return this;
  }

  /**
   * i18n value to translate
   * @return i18nValue
  **/
  //@ApiModelProperty(value = "i18n value to translate")
  public I18n getI18nValue() {
    return i18nValue;
  }

  public void setI18nValue(I18n i18nValue) {
    this.i18nValue = i18nValue;
  }

  public FieldToTranslate process(String process) {
    this.process = process;
    return this;
  }

  /**
   * Id of the process
   * @return process
  **/
  //@ApiModelProperty(value = "Id of the process")
  public String getProcess() {
    return process;
  }

  public void setProcess(String process) {
    this.process = process;
  }

  public FieldToTranslate processVersion(String processVersion) {
    this.processVersion = processVersion;
    return this;
  }

  /**
   * Version of the process
   * @return processVersion
  **/
  //@ApiModelProperty(value = "Version of the process")
  public String getProcessVersion() {
    return processVersion;
  }

  public void setProcessVersion(String processVersion) {
    this.processVersion = processVersion;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FieldToTranslate fieldToTranslate = (FieldToTranslate) o;
    return Objects.equals(this.i18nValue, fieldToTranslate.i18nValue) &&
        Objects.equals(this.process, fieldToTranslate.process) &&
        Objects.equals(this.processVersion, fieldToTranslate.processVersion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(i18nValue, process, processVersion);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FieldToTranslate {\n");
    
    sb.append("    i18nValue: ").append(toIndentedString(i18nValue)).append("\n");
    sb.append("    process: ").append(toIndentedString(process)).append("\n");
    sb.append("    processVersion: ").append(toIndentedString(processVersion)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

