package org.opfab.cards.model;

import java.util.Objects;
import java.util.ArrayList;
import java.util.List;
import org.opfab.cards.model.Recipient;

import com.fasterxml.jackson.annotation.JsonInclude;
/**
 * Recipient object defines rules for recipient computation
 */
//@ApiModel(description = "Recipient object defines rules for recipient computation")


@JsonInclude(JsonInclude.Include.NON_NULL)
public class Recipient   {
  private org.opfab.cards.model.RecipientEnum type = null;

  
  private List<Recipient> recipients = null;

  private String identity = null;

  public Recipient type(org.opfab.cards.model.RecipientEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Specifies the recipient type. Please note that DEADEND do not expose any other properties
   * @return type
  **/
  //@ApiModelProperty(required = true, value = "Specifies the recipient type. Please note that DEADEND do not expose any other properties")
  public org.opfab.cards.model.RecipientEnum getType() {
    return type;
  }

  public void setType(org.opfab.cards.model.RecipientEnum type) {
    this.type = type;
  }

  public Recipient recipients(List<Recipient> recipients) {
    this.recipients = recipients;
    return this;
  }

  public Recipient addRecipientsItem(Recipient recipientsItem) {
    if (this.recipients == null) {
      this.recipients = new ArrayList<>();
    }
    this.recipients.add(recipientsItem);
    return this;
  }

  /**
   * Used by UNION with multiple Recipients.
   * @return recipients
  **/
  //@ApiModelProperty(value = "Used by UNION with multiple Recipients.")
  public List<Recipient> getRecipients() {
    return recipients;
  }

  public void setRecipients(List<Recipient> recipients) {
    this.recipients = recipients;
  }

  public Recipient identity(String identity) {
    this.identity = identity;
    return this;
  }

  /**
   * Used by USER, GROUP
   * @return identity
  **/
  //@ApiModelProperty(value = "Used by USER, GROUP")
  public String getIdentity() {
    return identity;
  }

  public void setIdentity(String identity) {
    this.identity = identity;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Recipient recipient = (Recipient) o;
    return Objects.equals(this.type, recipient.type) &&
        Objects.equals(this.recipients, recipient.recipients) &&
        Objects.equals(this.identity, recipient.identity);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, recipients, identity);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Recipient {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    recipients: ").append(toIndentedString(recipients)).append("\n");
    sb.append("    identity: ").append(toIndentedString(identity)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

