package org.opfab.cards.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonInclude;
/**
 * CardCreationReport
 */


@JsonInclude(JsonInclude.Include.NON_NULL)
public class CardCreationReport   {
  private Integer count = null;

  private String message = null;

  public CardCreationReport count(Integer count) {
    this.count = count;
    return this;
  }

  /**
   * Number of created cards
   * @return count
  **/
  //@ApiModelProperty(required = true, value = "Number of created cards")
  public Integer getCount() {
    return count;
  }

  public void setCount(Integer count) {
    this.count = count;
  }

  public CardCreationReport message(String message) {
    this.message = message;
    return this;
  }

  /**
   * Get message
   * @return message
  **/
  //@ApiModelProperty(required = true, value = "")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CardCreationReport cardCreationReport = (CardCreationReport) o;
    return Objects.equals(this.count, cardCreationReport.count) &&
        Objects.equals(this.message, cardCreationReport.message);
  }

  @Override
  public int hashCode() {
    return Objects.hash(count, message);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CardCreationReport {\n");
    
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

