package org.opfab.cards.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonInclude;
/**
 * Created card identifiers
 */
//@ApiModel(description = "Created card identifiers")


@JsonInclude(JsonInclude.Include.NON_NULL)
public class CardCreationReport   {
  private String id = null;

  private String uid = null;

  public CardCreationReport id(String id) {
    this.id = id;
    return this;
  }

  /**
   * ID of the process instance to which this card refers
   * @return id
  **/
  //@ApiModelProperty(value = "ID of the process instance to which this card refers")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public CardCreationReport uid(String uid) {
    this.uid = uid;
    return this;
  }

  /**
   * Unique card ID
   * @return uid
  **/
  //@ApiModelProperty(value = "Unique card ID")
  public String getUid() {
    return uid;
  }

  public void setUid(String uid) {
    this.uid = uid;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CardCreationReport cardCreationReport = (CardCreationReport) o;
    return Objects.equals(this.id, cardCreationReport.id) &&
        Objects.equals(this.uid, cardCreationReport.uid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, uid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CardCreationReport {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    uid: ").append(toIndentedString(uid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

