/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: AppliedWorkitemExtractor.java 3310 2006-09-14 14:21:14Z jmettraux $
 */

//
// AppliedWorkitemExtractor.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.worklist.tools;

import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.util.beancoder.XmlBeanCoder;
import openwfe.org.engine.workitem.XmlCoderLoader;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.ParticipantExpression;
import openwfe.org.engine.expressions.state.FrozenState;
import openwfe.org.engine.expressions.state.ExpressionState;
import openwfe.org.engine.impl.workitem.xml.XmlWorkItemCoder;
import openwfe.org.worklist.impl.store.FileWorkItemStorage;


/**
 * This tool is for extracting applied workitems stuck in a participant
 * expression persisted to the filesystem. It's thus a rescue tool.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: AppliedWorkitemExtractor.java 3310 2006-09-14 14:21:14Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class AppliedWorkitemExtractor
{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(AppliedWorkitemExtractor.class.getName());

    //
    // CONSTRUCTORS

    private AppliedWorkitemExtractor ()
    {
        super();
    }

    //
    // STATIC METHODS

    private static void printUsage (final String cmd)
    {
        //
        // back from Basel
        // stopping at Olten
        //
        // Sat Mar  4 22:35:04 CET 2006
        //

        System.out.println();
        System.out.println("  usage :");
        System.out.println();
        System.out.println("  "+cmd+" [-f] {participantExpressionXmlFile}");
        System.out.println();
        System.out.println("  This extractor will take care of recreating the applied workitem found in");
        System.out.println("  the given participant expression.");
        System.out.println();
        System.out.println("  if '-f' is given, the extractor will attempt to extract a frozen item");
        System.out.println();
    }

    public static void main (final String[] args)
        throws Exception
    {
        boolean seekFrozen = false;

        if (args.length < 2)
        {
            printUsage(args[0]);
            System.exit(1);
        }

        if (args.length > 2)
        {
            if (args[1].equals("-f")) seekFrozen = true;
        }

        final String fileName = args[1];

        final ParticipantExpression pe = 
            (ParticipantExpression)XmlBeanCoder.load(fileName);

        InFlowWorkItem wi = pe.getAppliedWorkitem();

        if (seekFrozen)
        {
            final ExpressionState state = pe.getState();

            if (state instanceof FrozenState)
                wi = ((FrozenState)state).getAppliedItem();
        }

        if (wi == null)
        {
            if (seekFrozen)
                System.out.println("No applied workitem found in participant.");
            else
                System.out.println("No frozen incoming workitem found in participant.");

            System.exit(-1);
        }

        final XmlCoderLoader cl = XmlCoderLoader
            .buildCoderLoader("etc/engine/coder-configuration.xml");

        final XmlWorkItemCoder wic = (XmlWorkItemCoder)cl.getXmlCoder();

        final byte[] encodedWi = (byte[])wic.encode(wi, null, null);

        final String outputFileName = FileWorkItemStorage
            .determineFileName(wi.getId());

        final java.io.FileOutputStream fos = 
            new java.io.FileOutputStream(outputFileName);
        fos.write(encodedWi);
        fos.flush();
        fos.close();

        System.out.println("workitem saved in "+outputFileName);
    }

}
