/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: WorkItemStore.java 3118 2006-08-30 14:38:36Z jmettraux $
 */

//
// WorkItemStore.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.worklist.store;

import javax.security.auth.Subject;

import openwfe.org.engine.workitem.CancelItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.FlowExpressionId;


/**
 * Implement this interface to store work items for a worklist.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 16:38:36 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: WorkItemStore.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public interface WorkItemStore
{

    //
    // CONSTANTS

    /**
     * This service parameter name 'participants' is used to determine 
     * which participant names a store will accept for storage.
     */
    public final static String P_PARTICIPANTS
        = "participants";

    //
    // METHODS

    /**
     * Returns the name of this store.
     */
    public String getName ();

    /**
     * Inserts a workitem in the store.
     * This method takes no Subject as parameter because it is used
     * by listeners, not clients.
     */
    public void store (InFlowWorkItem wi)
        throws StoreException;

    /**
     * 'Cancels' a workitem, either remove it, either flags it as cancelled
     */
    public void cancel (CancelItem ci)
        throws StoreException;

    /**
     * Delegate works to this workitem store
     */
    public void delegate (InFlowWorkItem wi)
        throws StoreException;

    /**
     * Delegate works to this workitem store
     */
    public void delegateToParticipant 
        (Subject s, InFlowWorkItem wi, String participantName)
    throws 
        StoreException;

    /**
     * Updates a workitem in the store
     */
    public void save (Subject s, InFlowWorkItem wi)
        throws StoreException;

    /**
     * Removes a workitem from the store
     */
    public void remove (Subject s, FlowExpressionId expressionId)
        throws StoreException;

    /**
     * Fetches a workitem from the store.
     */
    public InFlowWorkItem get (Subject s, FlowExpressionId expressionId)
        throws StoreException;

    /**
     * Fetches a workitem, the store will tag it as locked.
     */
    public InFlowWorkItem getAndLock (Subject s, FlowExpressionId expressionId)
        throws StoreException;

    /**
     * Releases the lock on a workitem
     */
    public void release (Subject s, FlowExpressionId workitemId)
        throws StoreException;

    /**
     * Returns the count of workitems found in this store.
     */
    public int countWorkItems (Subject s)
        throws StoreException;

    /**
     * Returns a list of headers for this store.
     * A header is a 'summary' of a workitem, it's built by a HeaderFactory.
     * For each store, a different header factory may be used, giving a
     * specific view on the workitems contained in the store.
     */
    public java.util.List getHeaders 
        (Subject s, int limit)
    throws 
        StoreException;

    /**
     * Returns true if this store has been parameterized as 'default'.
     */
    public boolean isDefaultStore ();

    /**
     * Returns the flowExpressionId instances of the workitems belonging
     * to the given workflow instance.
     */
    public java.util.List findFlowInstance
        (Subject s, String workflowInstanceId)
    throws 
        StoreException;

    /**
     * Returns a list of headers for this store, a comparator passed as
     * argument takes care of sorting the headers found.
     * A header is a 'summary' of a workitem, it's built by a HeaderFactory.
     * For each store, a different header factory may be used, giving a
     * specific view on the workitems contained in the store.
     */
    public java.util.List getHeaders 
        (Subject s, int limit, java.util.Comparator headerComparator)
    throws 
        StoreException;

    /**
     * Will return true if the given subject has a lock on the workitem
     * designated by its lastExpressionId.
     */
    public boolean hasLockOn (Subject s, FlowExpressionId expressionId);

    /**
     * Returns true if the given workitem is locked.
     */
    public boolean isLocked (FlowExpressionId workitemId);

    /**
     * Returns the lock currently set on the workitem, will return null
     * if there is no lock on the workitem.
     */
    public Lock getLock (FlowExpressionId workitemId);

    /**
     * Returns true if the store accepts workitems for the given
     * participant.
     */
    public boolean acceptsWorkItemsFor (String participantName);

    /**
     * This method will return true if the current user/codebase has the
     * right to perform the given action on this store.
     */
    public boolean checkPermission (String action);

}
