/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: WorkItemStorage.java 3118 2006-08-30 14:38:36Z jmettraux $
 */

//
// WorkItemStorage.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.worklist.store;

import javax.security.auth.Subject;

import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.FlowExpressionId;


/**
 * Where a workitem store does the high-level work, the workitem storage does
 * the bulk work : physically storing the workitems.
 * Then the workitem store may take care of correlations and stuff like that.
 * A workitem storage is able to work for multiple stores.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: WorkItemStorage.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public interface WorkItemStorage
{

    /**
     * Inserts a workitem into the storage for given store.
     */
    public void storeWorkItem 
        (String storeName, InFlowWorkItem wi)
    throws 
        StoreException;

    /**
     * Removes the workitem from the storage for a given store.
     */
    public void removeWorkItem 
        (String storeName, FlowExpressionId fei)
    throws 
        StoreException;

    /**
     * Retrieves a workitem given the storename and the workitem id.
     */
    public InFlowWorkItem retrieveWorkItem 
        (String storeName, FlowExpressionId fei)
    throws 
        StoreException;

    /**
     * Returns the number of workitems in a store.
     */
    public int countWorkItems 
        (String storeName)
    throws 
        StoreException;

    /**
     * Returns a list of workitems from a store.
     */
    public java.util.List listWorkItems 
        (String storeName, int limit)
    throws 
        StoreException;

}
