
DROP TABLE workitem;
CREATE TABLE workitem (
  workitem_id varchar(13) NOT NULL primary key,
  participant_name varchar(255) NOT NULL,
  dispatch_time varchar(100) NOT NULL,
  last_modified varchar(100) NOT NULL,
  msg_err varchar(255) default NULL
);

DROP TABLE flow_expression_id;
CREATE TABLE flow_expression_id
(
  workitem_id varchar(13) not null,
  stack_index int NOT NULL,
  engine_id varchar(255) NOT NULL,
  wfd_url varchar(255) NOT NULL,
  wfd_name varchar(255) NOT NULL,
  wfd_revision varchar(255) NOT NULL,
  wf_instance_id varchar(13) NOT NULL,
  expression_name varchar(255) NOT NULL,
  expression_id int NOT NULL
);
CREATE UNIQUE INDEX feiWkItIdSt ON flow_expression_id(workitem_id, stack_index);

DROP TABLE attribute;
CREATE TABLE attribute
(
  workitem_id varchar(13) NOT NULL,
  id varchar(13) NOT NULL,
  parent_id varchar(13) default NULL,
  a_type varchar(100) default NULL,
  a_value long varchar default NULL
);  
CREATE UNIQUE INDEX aWkItIdId ON attribute(workitem_id, id);

DROP TABLE history_item;  
CREATE TABLE history_item
(
  workitem_id varchar(13) NOT NULL,
  id int NOT NULL,
  hi_date varchar(100) NOT NULL,
  author varchar(255) NOT NULL,
  host varchar(255) NOT NULL,
  hi_text long varchar NOT NULL,
  wfd_name varchar(255) NOT NULL,
  wfd_revision varchar(255) NOT NULL,
  wf_instance_id varchar(13) NOT NULL,
  userid varchar(32) default NULL
);
CREATE UNIQUE INDEX hiWkItIdId ON history_item(workitem_id, id);

DROP TABLE filter;
CREATE TABLE filter
(
  workitem_id varchar(13) NOT NULL,
  name varchar(255) NOT NULL,
  f_type varchar(1) NOT NULL,
  add_allowed varchar(1) NOT NULL,
  remove_allowed varchar(1) NOT NULL
);

DROP TABLE filter_entry;
CREATE TABLE filter_entry
(
  workitem_id varchar(13) NOT NULL,
  regex varchar(255) NOT NULL,
  permissions varchar(3) NOT NULL,
  attributeType varchar(255) default NULL
);
CREATE UNIQUE INDEX feWkItIdRe ON filter_entry(workitem_id, regex);

DROP TABLE action;
CREATE TABLE action
(
  workitem_id char(13) NOT NULL,
  action  varchar(255) NOT NULL,
  arg     varchar(255) default NULL,
  msg_err varchar(255) default NULL
);
CREATE UNIQUE INDEX aWkItIdAc ON action(workitem_id, action, arg);
