/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * . Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: SqlWorkItemCoder.java 3118 2006-08-30 14:38:36Z jmettraux $
 */

//
// SqlWorkItemCoder.java
//
// john.mettraux@openwfe.org
//
// generated with
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.worklist.impl.swis;

import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.sql.SqlUtils;
import openwfe.org.sql.ds.OwfeDataSource;
import openwfe.org.misc.UniqueIdGenerator;
import openwfe.org.engine.listen.reply.ListenerReplyCoder;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.CodingException;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.AttributeCoder;
import openwfe.org.engine.workitem.AttributeCoder;
import openwfe.org.engine.workitem.HistoryItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.StringMapAttribute;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.participants.Filter;
import openwfe.org.engine.participants.FilterEntry;
import openwfe.org.engine.impl.workitem.AbstractWorkItemCoder;

import openwfe.org.MapUtils;

/**
 * This implementation details how the 'swis' stores workitem in a RDBMS
 * (it outputs vanilla SQL)
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: SqlWorkItemCoder.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 * @author jay.lawrence@openwfe.org
 */
public class SqlWorkItemCoder

    extends AbstractWorkItemCoder

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(SqlWorkItemCoder.class.getName());

    //
    // CONSTANTS & co

    protected final static String WID = "workitem_id";
    protected final static String WFID = "wf_instance_id";

    protected final static String WORKITEM_TABLE = "workitem";

    protected final static String[] WORKITEM_COLS = new String[]
    {
        WID, "participant_name", "dispatch_time", "last_modified"
    };

    protected final static String FEI_TABLE = "flow_expression_id";

    protected final static String[] FEI_COLS = new String[]
    {
        WID, "stack_index", "engine_id", "initial_engine_id", "wfd_url",
        "wfd_name", "wfd_revision", WFID, "expression_name", "expression_id"
    };

    protected final static String HISTORY_TABLE = "history_item";

    protected final static String[] HISTORY_COLS = new String[]
    {
        WID, "id", "hi_date", "author", "host", "hi_text", "wfd_name",
        "wfd_revision", WFID
    };

    protected final static String FILTER_TABLE = "filter";

    protected final static String[] FILTER_COLS = new String[]
    {
        WID, "name", "f_type", "add_allowed", "remove_allowed"
    };

    protected final static String FILTER_ENTRY_TABLE = "filter_entry";

    protected final static String[] FILTER_ENTRY_COLS = new String[]
    {
        WID, "regex", "permissions", "attributeType"
    };

    protected final static String ATTRIBUTE_TABLE = "attribute";
    protected final static String[] ATTRIBUTE_COLS = new String[]
    {
        SqlWorkItemCoder.WID, "id", "parent_id", "a_type", "a_value"
    };

    //
    // FIELDS

    protected java.util.Map perRepresentationMap = null;

    protected static UniqueIdGenerator uidGenerator = new UniqueIdGenerator();

    //
    // CONSTRUCTORS

    public void init
        (final String name,
         final java.util.List attributeCoders,
         final ListenerReplyCoder replyCoder,
         final java.util.Map coderParams)
    {
        super.init(name, attributeCoders, replyCoder, coderParams);

        this.perRepresentationMap =
            new java.util.HashMap(attributeCoders.size());

        java.util.Iterator it = attributeCoders.iterator();
        while (it.hasNext())
        {
            AbstractSqlAttributeCoder coder =
                (AbstractSqlAttributeCoder)it.next();

            this.perRepresentationMap.put
                (coder.getRepresentationName(), coder);

            log.debug
                ("init() put '"+coder.getClass().getName()+
                 "' for '"+coder.getRepresentationName()+"'");
        }
    }

    //
    // METHODS from WorkItemCoder

    /**
     * Returns the MIME type associated with this coder.
     */
    public String getMimeType ()
    {
        return "application/sql";
            //
            // an invention
    }

    public Object encode
        (final WorkItem wi,
         final ApplicationContext context,
         final java.util.Map serviceParams)
    throws
        CodingException
    {
        log.debug("encode()");

        if ( ! (wi instanceof InFlowWorkItem))
        {
            throw new CodingException
                ("This workItemCoder doesn't support encoding something else "+
                 "than an InFlowWorkItem");
        }

        final InFlowWorkItem item = (InFlowWorkItem)wi;

        log.debug("encode() "+item.getLastExpressionId());

        //
        // lookup data source

        final OwfeDataSource ds = lookupDataSource(context, serviceParams);

        //
        // create batch statement

        java.sql.Statement st = null;
        try
        {
            st = ds.getConnection().createStatement();

            encode(st, item);

            st.executeBatch();
        }
        catch (java.sql.SQLException se)
        {
            ds.logSQLException( "encode", log, se );
            log.error("encode (insert) failure", se);
            throw new CodingException
                ("encode (insert) failure", se);
        }
        finally
        {
            SqlUtils.closeStatement(st);
            ds.releaseConnection();
        }

        return null;
    }

    public WorkItem decode
        (final Object o,
         final ApplicationContext context,
         final java.util.Map serviceParams)
    throws
        CodingException
    {
        long workitemId = -1;
        FlowExpressionId fei = null;

        if (o instanceof FlowExpressionId)
            fei = (FlowExpressionId)o;
        else
            workitemId = ((Long)o).longValue();

        OwfeDataSource ds = null;
        try
        {
            ds = lookupDataSource(context, serviceParams);

            if (workitemId < 0)
                workitemId = determineWorkitemId(ds.getConnection(), fei);
            else
                fei = determineFlowExpressionId(ds.getConnection(), workitemId);

            return decode(ds, fei, workitemId);
        }
        catch (java.sql.SQLException se)
        {
            throw new CodingException
                ("Failed to decode workitem with fei "+fei, se);
        }
        finally
        {
            if (ds != null) ds.releaseConnection();
        }
    }

    //
    // METHODS

    public AbstractSqlAttributeCoder getAttributeCoder
        (final String representationName)
    {
        /*
        log.debug
            ("getAttributeCoder() this.perRepresentationMap is "+
             this.perRepresentationMap);
        log.debug
            ("getAttributeCoder() repr to find is '"+representationName+"'");
        */
        return (AbstractSqlAttributeCoder)this.perRepresentationMap
            .get(representationName);
    }

    //
    // encoding
    //

    protected void encode
        (final java.sql.Statement st, final InFlowWorkItem wi)
    throws
        java.sql.SQLException, CodingException
    {
        //
        // generate id for the workitem

        final Long workitemId = (Long)uidGenerator.generateUniqueId();
        log.debug("Building SWIS insert batch");
        st.addBatch(buildWorkItemSql(workitemId, wi));

        //
        // generate batch statements for payload and routing info
        // of workitem

        encode(st, workitemId, -1, wi.getLastExpressionId());
            // stackIndex is set to -1 for the 'last expression id'
            // when >= 0, it means it's a flow stack entry

        //encode(st, workitemId, wi.getFlowStack(), wi);
        encode(st, workitemId, wi.getAttributes());

        if (wi.getFilter() != null)
            encode(st, workitemId, wi.getFilter());

        encode(st, workitemId, wi.getHistory(), wi);
        log.debug("Finished SWIS insert batch");

    }

    protected String buildWorkItemSql
        (final Long workitemId, final InFlowWorkItem wi)
    {
        //
        // generate batch statements for inserting core workitem data

        final java.util.List values =
            new java.util.ArrayList(WORKITEM_COLS.length);

        values.add(workitemId.toString());
        values.add(wi.getParticipantName());
        values.add(wi.getDispatchTime());
        values.add(wi.getLastModified());

        final String sInsert = SqlUtils.buildInsertString
            (WORKITEM_TABLE,
             WORKITEM_COLS,
             values);

        log.debug("buildWorkItemSql() "+sInsert );

        return sInsert;
    }


    protected void encode
        (final java.sql.Statement st,
         final Long workitemId,
         final int stackIndex,
         final FlowExpressionId fei)
         //final InFlowWorkItem wi)
    throws
        java.sql.SQLException
    {
        final java.util.List values = new java.util.ArrayList(FEI_COLS.length);
        values.add(workitemId.toString());
        values.add(new Integer(stackIndex));
        values.add(fei.getEngineId());
        values.add(fei.getInitialEngineId());
        values.add(fei.getWorkflowDefinitionUrl());
        values.add(fei.getWorkflowDefinitionName());
        values.add(fei.getWorkflowDefinitionRevision());
        values.add(fei.getWorkflowInstanceId());
        values.add(fei.getExpressionName());
        values.add(fei.getExpressionId());

        final String sInsert = SqlUtils.buildInsertString
            (FEI_TABLE,
             FEI_COLS,
             values);

        log.debug("addBatch() "+sInsert );
        st.addBatch(sInsert);
    }

    protected void encode
        (final java.sql.Statement st,
         final Long workitemId,
         final int id,
         final HistoryItem hi,
         final InFlowWorkItem wi)
    throws
        java.sql.SQLException
    {
        final java.util.List values =
            new java.util.ArrayList(HISTORY_COLS.length);
        values.add(workitemId.toString());
        values.add(new Integer(id));
        values.add(hi.getDate());
        values.add(hi.getAuthor());
        values.add(hi.getHost());
        values.add(hi.getText());
        values.add(hi.getWorkflowDefinitionName());
        values.add(hi.getWorkflowDefinitionRevision());
        values.add(hi.getWorkflowInstanceId());

        final String sInsert = SqlUtils.buildInsertString
            (HISTORY_TABLE,
             HISTORY_COLS,
             values);

        log.debug("addBatch() "+sInsert );
        st.addBatch(sInsert);
    }

    protected void encode
        (final java.sql.Statement st,
         final Long workitemId,
         final java.util.List list,
         final InFlowWorkItem wi)
    throws
        java.sql.SQLException
    {
        if (list.size() < 1) return;

        Object o = list.get(0);

        if (o instanceof HistoryItem)
        {
            for (int i=0; i<list.size(); i++)
                encode(st, workitemId, i, (HistoryItem)list.get(i), wi);
        }
        else if (o instanceof FlowExpressionId)
        {
            for (int i=0; i<list.size(); i++)
                encode(st, workitemId, i, (FlowExpressionId)list.get(i));
        }
        else
        {
            throw new IllegalArgumentException
                ("cannot encode list of "+o.getClass()+" instances");
        }
    }

    protected void encode
        (final java.sql.Statement st,
         final Long workitemId,
         final StringMapAttribute smap)
    throws
        java.sql.SQLException, CodingException
    {
            final String sWhere = " WHERE "+WID+" = '"+workitemId+"'";
            st.addBatch("DELETE FROM "+ATTRIBUTE_TABLE+sWhere);
        final java.util.Map params = AbstractSqlAttributeCoder.prepareParams
            (st, workitemId, 0, -1);

        Long lid = (Long)this.getAttributeCoder(smap)
            .encode(smap, params);

        log.debug
            ("encode() seem to have inserted "+(lid.longValue()+1)+
             " attributes");
    }

    protected void encode
        (final java.sql.Statement st,
         final Long workitemId,
         final FilterEntry filterEntry)
    throws
        java.sql.SQLException
    {
        final java.util.List values =
            new java.util.ArrayList(FILTER_ENTRY_COLS.length);
        values.add(workitemId.toString());
        values.add(filterEntry.getFieldRegex());
        values.add(filterEntry.getPermissions());

        //values.add(filterEntry.getAttributeType());
        values.add("");
            // forget the attribute type for the moment, it
            // will perhaps be reactivated at a later time
            // (John)

        final String sInsert = SqlUtils.buildInsertString
            (FILTER_ENTRY_TABLE,
             FILTER_ENTRY_COLS,
             values);

        log.debug("addBatch() "+sInsert );
        st.addBatch(sInsert);
    }

    protected void encode
        (final java.sql.Statement st,
         final Long workitemId,
         final Filter filter)
    throws
        java.sql.SQLException
    {
        final java.util.List values =
            new java.util.ArrayList(FILTER_COLS.length);

        values.add(workitemId.toString());
        values.add(filter.getName());

        if (filter.getType() == Filter.TYPE_OPEN)
            values.add("o");
        else
            values.add("c");

        if (filter.isAddAllowed())
            values.add("t");
        else
            values.add("f");

        if (filter.isRemoveAllowed())
            values.add("t");
        else
            values.add("f");

        final String sInsert = SqlUtils.buildInsertString
            (FILTER_TABLE,
             FILTER_COLS,
             values);

        log.debug("addBatch() "+sInsert );
        st.addBatch(sInsert);

        java.util.Iterator it = filter.getEntries().iterator();
        while (it.hasNext())
        {
            FilterEntry fe = (FilterEntry)it.next();
            encode(st, workitemId, fe);
        }
    }

    //
    // decoding

    protected InFlowWorkItem decode
        (final OwfeDataSource ds,
         final FlowExpressionId lastExpressionId,
         final long workitemId)
    throws
        java.sql.SQLException, CodingException
    {
        final String sWhere = WID + " = '" + workitemId + "'";

        final String sQuery = SqlUtils.buildQueryString
            (WORKITEM_TABLE, WORKITEM_COLS, sWhere);

        final InFlowWorkItem wi = new InFlowWorkItem();
        wi.setId(lastExpressionId);

        java.sql.Statement st = null;
        java.sql.ResultSet rs = null;
        try
        {
            st = ds.getConnection().createStatement();
            rs = st.executeQuery(sQuery);

            if ( ! rs.next())
            {
                throw new CodingException
                    ("Didn't find any workitem with id "+workitemId+
                     " for "+lastExpressionId);
            }

            wi.setParticipantName(rs.getString(2));
            wi.setDispatchTime(rs.getString(3));
            wi.setLastModified(rs.getString(4));
        }
        catch (java.sql.SQLException se)
        {
                ds.logSQLException( "decode", log, se );
                throw new CodingException( "Could not decode() workitemId " + workitemId );
        }
        finally
        {
            SqlUtils.closeStatement(st, rs);
        }

        //decodeFlowStack(ds, wi, workitemId);
        decodeAttributes(ds, wi, workitemId);
        decodeHistory(ds, wi, workitemId);
        decodeFilter(ds, wi, workitemId);

        return wi;
    }

    /*
    protected void decodeFlowStack
        (final OwfeDataSource ds,
         final InFlowWorkItem wi,
         final long workitemId)
    throws
        java.sql.SQLException, CodingException
    {
        log.debug("decodeFlowStack()");

        final String sWhere =
            WID + " = '" + workitemId + "' AND " +
            "stack_index >= 0";
        final String sOrder =
            "stack_index";
        final String sQuery = SqlUtils.buildQueryString
            (FEI_TABLE, FEI_COLS, sWhere, sOrder);

        java.sql.Statement st = null;
        java.sql.ResultSet rs = null;
        try
        {
            final java.util.List flowStack = new java.util.ArrayList(14);

            st = ds.getConnection().createStatement();
            rs = st.executeQuery(sQuery);

            while (rs.next())
                flowStack.add(extractFlowExpressionId(rs));

            wi.setFlowStack(flowStack);
        }
        catch (java.sql.SQLException se)
        {
                ds.logSQLException( "decodeFlowStack", log, se );
                throw new CodingException( "Could not decodeFlowStack() flowStack for workitemId " + workitemId );
        }
        finally
        {
            SqlUtils.closeStatement(st, rs);
        }
    }
    */

    protected void decodeAttributes
        (final OwfeDataSource ds,
         final InFlowWorkItem wi,
         final long workitemId)
    throws
        java.sql.SQLException, CodingException
    {
        log.debug("decodeAttributes()");

        final String sWhere =
            WID + " = '" + workitemId + "'";
        final String sOrder =
            "id";
        final String sQuery = SqlUtils.buildQueryString
            (ATTRIBUTE_TABLE, ATTRIBUTE_COLS, sWhere, sOrder);

        java.sql.Statement st = null;
        java.sql.ResultSet rs = null;
        try
        {
            st = ds.getConnection().createStatement();
            rs = st.executeQuery(sQuery);

            final java.util.List result = new java.util.ArrayList(49);

            while (rs.next())
                result.add(new AttributeRecord(rs));

            java.util.Map args = new java.util.HashMap(1);
            args.put(AbstractSqlAttributeCoder.ARG_ATT_RECORD_LIST, result);

            //
            // decode attribute whose id is 0 (root smap)

            wi.setAttributes
                ((StringMapAttribute)getAttributeCoder(StringMapAttribute.class)
                    .decode(new Long(0), args));
        }
        catch (java.sql.SQLException se)
        {
                ds.logSQLException( "decodeAttributes", log, se );
                throw new CodingException( "Could not decodeAttributes() attributes for workitemId " + workitemId );
        }
        finally
        {
            SqlUtils.closeStatement(st, rs);
        }
    }

    protected void decodeHistory
        (final OwfeDataSource ds,
         final InFlowWorkItem wi,
         final long workitemId)
    throws
        java.sql.SQLException, CodingException
    {
        log.debug("decodeHistory()");

        final String sWhere = "workitem_id = '" + workitemId + "'";
        final String sOrder = "id";

        final String sQuery = SqlUtils.buildQueryString
            (HISTORY_TABLE, HISTORY_COLS, sWhere, sOrder);

        java.sql.Statement st = null;
        java.sql.ResultSet rs = null;
        try
        {
            st = ds.getConnection().createStatement();
            rs = st.executeQuery(sQuery);

            final java.util.List history = new java.util.ArrayList(49);

            while (rs.next())
                history.add(extractHistoryItem(rs));

            wi.setHistory(history);
        }
        catch (java.sql.SQLException se)
        {
                ds.logSQLException( "decodeHistory", log, se );
                throw new CodingException( "Could not decode() history for workitemId " + workitemId );
        }
        finally
        {
            SqlUtils.closeStatement(st, rs);
        }
    }

    protected void decodeFilter
        (final OwfeDataSource ds,
         final InFlowWorkItem wi,
         final long workitemId)
    throws
        java.sql.SQLException, CodingException
    {
        log.debug("decodeFilter()");

        java.sql.Statement st = null;
        java.sql.ResultSet rs = null;
        try
        {
            //
            // extract filter itself (if any)

            final String sWhere =
                WID + " = '" + workitemId + "'";
            String sQuery = SqlUtils.buildQueryString
                (FILTER_TABLE, FILTER_COLS, sWhere);

            st = ds.getConnection().createStatement();
            rs = st.executeQuery(sQuery);

            if ( ! rs.next()) return;
                // no filter for this workitem

            final Filter filter = extractFilter(rs);

            try
            {
                rs.close();
            }
            catch (java.sql.SQLException se)
            {
                // ignore
            }

            //
            // extract filter entries

            sQuery = SqlUtils.buildQueryString
                (FILTER_ENTRY_TABLE, FILTER_ENTRY_COLS, sWhere);

            rs = st.executeQuery(sQuery);

            final java.util.List entries = new java.util.ArrayList(49);

            while (rs.next())
                entries.add(extractFilterEntry(rs));

            filter.setEntries(entries);

            wi.setFilter(filter);
        }
        catch (java.sql.SQLException se)
        {
                ds.logSQLException( "decodeFilter", log, se );
                throw new CodingException( "Could not decode() filters for workitemId " + workitemId );
        }
        finally
        {
            SqlUtils.closeStatement(st, rs);
        }
    }

    //
    // STATIC METHODS

    protected static Filter extractFilter
        (final java.sql.ResultSet rs)
    throws
        java.sql.SQLException
    {
        final Filter f = new Filter();

        int i = 2;

        f.setName(rs.getString(i++));

        final char cType = rs.getString(i++).toLowerCase().charAt(0);
        if (cType == 'o')
            f.setType(Filter.TYPE_OPEN);
        else
            f.setType(Filter.TYPE_CLOSED);

        final char cAddAllowed = rs.getString(i++).toLowerCase().charAt(0);
        f.setAddAllowed(cAddAllowed == 't');

        final char cRemoveAllowed = rs.getString(i++).toLowerCase().charAt(0);
        f.setRemoveAllowed(cRemoveAllowed == 't');

        return f;
    }

    protected static FilterEntry extractFilterEntry
        (final java.sql.ResultSet rs)
    throws
        java.sql.SQLException
    {
        final FilterEntry fe = new FilterEntry();

        int i = 2;

        fe.setFieldRegex(rs.getString(i++));
        fe.setPermissions(rs.getString(i++));

        //fe.setAttributeType(rs.getString(i++));
            // forget it for the moment, it will perhaps be
            // reactivated at a later time
            // (John)

        return fe;
    }

    protected static HistoryItem extractHistoryItem
        (final java.sql.ResultSet rs)
    throws
        java.sql.SQLException
    {
        final HistoryItem hi = new HistoryItem();

        int i = 3;

        hi.setDate(rs.getString(i++));
        hi.setAuthor(rs.getString(i++));
        hi.setHost(rs.getString(i++));
        hi.setText(rs.getString(i++));
        hi.setWorkflowDefinitionName(rs.getString(i++));
        hi.setWorkflowDefinitionRevision(rs.getString(i++));
        hi.setWorkflowInstanceId(rs.getString(i++));

        return hi;
    }

    protected static FlowExpressionId extractFlowExpressionId
        (final java.sql.ResultSet rs)
    throws
        java.sql.SQLException
    {
        final FlowExpressionId fei = new FlowExpressionId();

        int i = 3;

        fei.setEngineId(rs.getString(i++));
        //fei.setInitialEngineId(rs.getString(i++));
        fei.setInitialEngineId( fei.getEngineId() );
        fei.setWorkflowDefinitionUrl(rs.getString(i++));
        fei.setWorkflowDefinitionName(rs.getString(i++));
        fei.setWorkflowDefinitionRevision(rs.getString(i++));
        fei.setWorkflowInstanceId(rs.getString(i++));
        fei.setExpressionName(rs.getString(i++));
        //fei.setExpressionId(rs.getInt(i++));
        fei.setExpressionId(rs.getString(i++));

        log.debug("extractFlowExpressionId() extracted "+fei);

        return fei;
    }

    protected static FlowExpressionId determineFlowExpressionId
        (final java.sql.Connection con,
         final long workitemId)
    throws
        java.sql.SQLException, CodingException
    {
        java.util.List feis = determineFlowExpressionIds
            (con, workitemId, -1, -1);

        if (feis == null || feis.size() < 1) return null;

        return (FlowExpressionId)feis.get(0);
    }

    protected static java.util.List determineFlowExpressionIds
        (final java.sql.Connection con,
         final long workitemId,
         final long workflowInstanceId,
         final int limit)
    throws
        java.sql.SQLException, CodingException
    {
        //
        // build query

        final StringBuffer sb = new StringBuffer();
        sb.append("stack_index = -1");
        if (workitemId > -1)
        {
            sb.append(" AND ");
            sb.append(WID); sb.append(" = '"); sb.append(workitemId); sb.append("'");
        }
        if (workflowInstanceId > -1)
        {
            sb.append(" AND ");
            sb.append(WFID); sb.append(" = "); sb.append(workflowInstanceId);
        }
        final String sWhere = sb.toString();

        final String sQuery = SqlUtils.buildQueryString
            (FEI_TABLE, FEI_COLS, sWhere);

        log.debug("determineFlowExpressionIds() query :\n"+sQuery);

        //
        // do query

        java.sql.Statement st = null;
        java.sql.ResultSet rs = null;
        try
        {
            st = con.createStatement();
            rs = st.executeQuery(sQuery);

            int size = limit;
            if (size < 1) size = 7;
                // no x?0:1 notation...

            java.util.List result = new java.util.ArrayList(size);

            while (rs.next())
            {
                result.add(extractFlowExpressionId(rs));
                if (limit > 0 && result.size() >= limit) break;
            }

            log.debug
                ("determineFlowExpressionIds() found "+result.size()+
                 " results");

            return result;
        }
        catch (java.sql.SQLException se)
        {
                // XXX pass in DataSource rather than connection
                // ds.logSQLException( "determineFlowExpressionIds", log, se );
                throw new CodingException( "Could not determineFlowExpressionIds() for workitemId " + workitemId );
        }
        finally
        {
            SqlUtils.closeStatement(st, rs);
        }
    }

    protected static long determineWorkitemId
        (final java.sql.Connection con, final FlowExpressionId fei)
    throws
        java.sql.SQLException, CodingException
    {
        final StringBuffer sb = new StringBuffer();

        sb.append("SELECT ");
        sb.append(WID);
        sb.append(" FROM ");
        sb.append(FEI_TABLE);
        sb.append(" WHERE ");
        sb.append(" stack_index = -1");
        sb.append(" AND");
        sb.append(" engine_id = ");
        sb.append(SqlUtils.prepareString(fei.getEngineId()));
        sb.append(" AND");
        sb.append(" initial_engine_id = ");
        sb.append(SqlUtils.prepareString(fei.getInitialEngineId()));
        sb.append(" AND");
        sb.append(" wfd_url = ");
        sb.append(SqlUtils.prepareString(fei.getWorkflowDefinitionUrl()));
        sb.append(" AND");
        sb.append(" wfd_name = ");
        sb.append(SqlUtils.prepareString(fei.getWorkflowDefinitionName()));
        sb.append(" AND");
        sb.append(" wfd_revision = ");
        sb.append(SqlUtils.prepareString(fei.getWorkflowDefinitionRevision()));
        sb.append(" AND");
        sb.append(" wf_instance_id = ");
        sb.append( SqlUtils.prepareString(fei.getWorkflowInstanceId()));
        sb.append(" AND");
        sb.append(" expression_name = ");
        sb.append(SqlUtils.prepareString(fei.getExpressionName()));
        sb.append(" AND");
        sb.append(" expression_id = ");
        sb.append(SqlUtils.prepareString(fei.getExpressionId()));
        // sb.append(";");

        String sQuery = sb.toString();
        log.debug( "determineWorkitemId() query: " + sQuery );

        //
        // do query

        java.sql.Statement st = null;
        java.sql.ResultSet rs = null;
        try
        {
            st = con.createStatement();
            rs = st.executeQuery(sQuery);

            if ( ! rs.next())
            {
                throw new CodingException
                    ("No workitem stored for "+fei);
            }

            return rs.getLong(1);
        }
        catch (java.sql.SQLException se)
        {
                // XXX pass in DataSource rather than connection
                // ds.logSQLException( "determineWorkitemId", log, se );
                throw new CodingException( "Could not determineWorkitemId() for wf_instance_id " + fei.getWorkflowInstanceId() );
        }
        finally
        {
            SqlUtils.closeStatement(st, rs);
        }
    }

    public static void removeWorkItem
        (final FlowExpressionId fei,
         final ApplicationContext context,
         final java.util.Map params)
    throws
        java.sql.SQLException, CodingException
    {
        OwfeDataSource ds = null;
        java.sql.Statement st = null;
        try
        {
            ds = lookupDataSource(context, params);

            final long workitemId =
                determineWorkitemId(ds.getConnection(), fei);

            log.debug("removeWorkItem() wid is "+workitemId);

            st = ds.getConnection().createStatement();

            final String sWhere = " WHERE "+WID+" = '"+workitemId+"'";
            log.debug("Where clause for deletion of workitem is: " + sWhere);

            st.addBatch("DELETE FROM "+WORKITEM_TABLE+sWhere);
            st.addBatch("DELETE FROM "+FEI_TABLE+sWhere);
            st.addBatch("DELETE FROM "+FILTER_TABLE+sWhere);
            st.addBatch("DELETE FROM "+FILTER_ENTRY_TABLE+sWhere);

            st.addBatch("DELETE FROM "+ATTRIBUTE_TABLE+sWhere);

            st.executeBatch();
        }
        catch (java.sql.SQLException se)
        {
                ds.logSQLException( "removeWorkItem", log, se );
        }
        finally
        {
            SqlUtils.closeStatement(st);
            if (ds != null) ds.releaseConnection();
        }
    }

    public static int countWorkItems (final OwfeDataSource ds)
        throws java.sql.SQLException, CodingException
    {
        java.sql.Statement st = null;
        java.sql.ResultSet rs = null;
        try
        {
            st = ds.getConnection().createStatement();

            rs = st.executeQuery
                ("SELECT count("+WID+") FROM "+WORKITEM_TABLE);

            if ( ! rs.next()) return -1;

            return rs.getInt(1);
        }
        catch (java.sql.SQLException se)
        {
                ds.logSQLException( "countWorkItems", log, se );
                throw new CodingException( "Could not countWorkItems()" );
        }
        finally
        {
            SqlUtils.closeStatement(st, rs);
        }
    }

    public static java.util.List findFlowInstance
        (final OwfeDataSource ds, final long workflowInstanceId)
    throws
        java.sql.SQLException, CodingException
    {
        return determineFlowExpressionIds
            (ds.getConnection(), -1, workflowInstanceId, -1);
    }

    protected static OwfeDataSource lookupDataSource
        (final ApplicationContext context,
         final java.util.Map params)
    throws
        CodingException
    {
        try
        {
            return SqlUtils.lookupDataSource(context, params);
        }
        catch (ServiceException se)
        {
            throw new CodingException
                ("Did not find dataSource", se);
        }
    }

    public static java.util.List listActionEntries (final OwfeDataSource ds)
        throws CodingException
    {
        java.sql.Statement st = null;
        java.sql.ResultSet rs = null;
        try
        {
            st = ds.getConnection().createStatement();

            rs = st.executeQuery
                ("SELECT "+WID+
                 ", action, arg FROM action where msg_err is null");

            final java.util.List result = new java.util.ArrayList();

            while (rs.next())
                result.add(new ActionEntry(rs));

            return result;
        }
        catch (final java.sql.SQLException se)
        {
            ds.logSQLException("listActionEntries()", log, se);
            throw new CodingException("listActionEntries() failed.", se);
        }
        catch (final Throwable t)
        {
            throw new CodingException("listActionEntries() failed", t);
        }
        finally
        {
            SqlUtils.closeStatement(st, rs);
            ds.releaseConnection();
        }
    }

    public static void removeActionEntry
        (final OwfeDataSource ds, final ActionEntry ae)
    throws
        java.sql.SQLException, CodingException
    {
        java.sql.Statement st = null;
        try
        {
            st = ds.getConnection().createStatement();
            st.execute("DELETE FROM action WHERE "+WID+" = "+ SqlUtils.prepareString( java.lang.Long.toString( ae.workitemId ) ) +" and action=" + SqlUtils.prepareString(ae.action) );

            //
            // for the moment, this method remove action entries based
            // on the workitem id, this may change...
            //
        }
        catch (java.sql.SQLException se)
        {
            ds.logSQLException( "removeActionEntry", log, se );
            throw new CodingException( "Could not removeActionEntry() for workitemId " + ae.workitemId );
        }
        finally
        {
            SqlUtils.closeStatement(st);
            ds.releaseConnection();
        }
    }

    public static void errorActionEntry
        (final OwfeDataSource ds, final ActionEntry ae, final String error)
    {
        java.sql.Statement st = null;
        try
        {
            st = ds.getConnection().createStatement();
            String sql = "UPDATE action set msg_err=" + SqlUtils.prepareString( error ) + " where " + WID
                + "=" + SqlUtils.prepareString( java.lang.Long.toString( ae.workitemId ) )
                + " and action=" + SqlUtils.prepareString( ae.action )
                ;
            log.debug( "errorActionEntry sql: " + sql );
            st.execute( sql );
        }
        catch (java.sql.SQLException se)
        {
            ds.logSQLException( "errorActionEntry", log, se );
            // throw new CodingException( "Could not errorActionEntry() for workitemId " + ae.workitemId );
        }
        finally
        {
            SqlUtils.closeStatement(st);
            ds.releaseConnection();
        }
    }

    //
    // AttributeRecord stuff

    static class AttributeRecord
    {
        public long id = -1;
        public long parentId = -1;
        public String type = null;
        public String value = null;

        public AttributeRecord (final java.sql.ResultSet rs)
            throws java.sql.SQLException
        {
            int i = 2;

            this.id = rs.getLong(i++);
            this.parentId = rs.getLong(i++);
            this.type = rs.getString(i++);
            this.value = rs.getString(i++);
        }
    }

    public static void removeRecord
        (final java.util.List attributeRecordList, final Long id)
    {
        final AttributeRecord ar = lookupRecord(attributeRecordList, id);
        attributeRecordList.remove(ar);
    }

    public static AttributeRecord lookupRecord
        (final java.util.List attributeRecordList, final Long id)
    {
        final java.util.Iterator it = attributeRecordList.iterator();
        while (it.hasNext())
        {
            final AttributeRecord record = (AttributeRecord)it.next();
            if (record.id == id.longValue()) return record;
        }

        return null;
    }

    public static java.util.List lookupRecords
        (final java.util.List attributeRecordList, final long parentId)
    {
        final java.util.List result =
            new java.util.ArrayList(attributeRecordList.size());

        final java.util.Iterator it = attributeRecordList.iterator();
        while (it.hasNext())
        {
            final AttributeRecord record = (AttributeRecord)it.next();
            if (record.parentId == parentId) result.add(record);
        }

        return result;
    }

}
