/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: MapAttributeCoder.java 3334 2006-09-17 06:19:18Z jmettraux $
 */

//
// MapAttributeCoder.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.worklist.impl.swis;

import openwfe.org.sql.SqlUtils;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.AttributeCoder;
import openwfe.org.engine.workitem.MapAttribute;
import openwfe.org.engine.workitem.CodingException;


/**
 * no comment
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-09-17 08:19:18 +0200 (Sun, 17 Sep 2006) $
 * <br>$Id: MapAttributeCoder.java 3334 2006-09-17 06:19:18Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class MapAttributeCoder

    extends CollectionAttributeCoder

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(MapAttributeCoder.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    //
    // METHODS from AttributeCoder

    public Object encode (final Attribute a, final java.util.Map args)
        throws CodingException
    {
        final java.sql.Statement st = (java.sql.Statement)args
            .get(ARG_STATEMENT);

        final Long workitemId = (Long)args
            .get(ARG_WID);
        final Long id = (Long)args
            .get(ARG_ID);
        final Long parentId = (Long)args
            .get(ARG_PID);

        //
        // insert self
        
        insert(st, workitemId, id, parentId, this.getRepresentationName());

        //
        // encode entries
        
        final MapAttribute ma = (MapAttribute)a;
        
        long availableId = id.longValue()+1;

        final java.util.Iterator it = ma.keySet().iterator();
        while (it.hasNext())
        {
            final Attribute aKey = (Attribute)it.next();
            final Attribute aValue = ma.aget(aKey);

            //
            // encode 'entry'
            //
            // key and value will be linked to it (key first (smallest id))

            final long entryId = availableId;

            insert(st, workitemId, new Long(availableId), id, null);

            availableId++;

            //
            // encode key

            final java.util.Map kParams = prepareParams
                (st, workitemId, availableId, entryId);

            Long aId = (Long)getWorkItemCoder().getAttributeCoder(aKey)
                .encode(aKey, kParams);

            availableId = aId.longValue();

            //
            // encode value

            final java.util.Map vParams = prepareParams
                (st, workitemId, availableId, entryId);

            aId = (Long)getWorkItemCoder().getAttributeCoder(aValue)
                .encode(aValue, vParams);

            availableId = aId.longValue();
        }
        
        //
        // that's all folks !

        return new Long(availableId);
    }

    public Attribute decode (final Object o, final java.util.Map args) 
        throws CodingException
    {
        final java.util.List attributeRecordList = AbstractSqlAttributeCoder
            .fetchAttributeRecordList(args);

        final Long attId = (Long)o;

        SqlWorkItemCoder.removeRecord(attributeRecordList, attId);

        MapAttribute result = null;
        try
        {
            final Class attributeClass = Class.forName(this.attributeClassName);
            result = (MapAttribute)attributeClass.newInstance();
        }
        catch (Exception e)
        {
            throw new CodingException
                ("Failed to instantiate map attribute", e);
        }

        //
        // list entries

        final java.util.List entries = SqlWorkItemCoder
            .lookupRecords(attributeRecordList, attId.longValue());

        //
        // for each entry decode key and value

        final java.util.Iterator it = entries.iterator();
        while (it.hasNext())
        {
            final SqlWorkItemCoder.AttributeRecord entry = 
                (SqlWorkItemCoder.AttributeRecord)it.next();

            args.remove(new Long(entry.id));

            final java.util.List keyAndValue = SqlWorkItemCoder
                .lookupRecords(attributeRecordList, entry.id);

            final SqlWorkItemCoder.AttributeRecord key =
                (SqlWorkItemCoder.AttributeRecord)keyAndValue.get(0);
            final SqlWorkItemCoder.AttributeRecord value =
                (SqlWorkItemCoder.AttributeRecord)keyAndValue.get(1);

            result.put
                (decodeChild(key.id, key.type, args), 
                 decodeChild(value.id, value.type, args));
        }

        return result;
    }

}
