/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ListAttributeCoder.java 3118 2006-08-30 14:38:36Z jmettraux $
 */

//
// ListAttributeCoder.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.worklist.impl.swis;

import openwfe.org.sql.SqlUtils;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.AttributeCoder;
import openwfe.org.engine.workitem.ListAttribute;
import openwfe.org.engine.workitem.CodingException;


/**
 * no comment
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 16:38:36 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: ListAttributeCoder.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class ListAttributeCoder

    extends CollectionAttributeCoder

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ListAttributeCoder.class.getName());

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    //
    // METHODS from AttributeCoder

    public Object encode (final Attribute a, final java.util.Map args)
        throws CodingException
    {
        final java.sql.Statement st = (java.sql.Statement)args
            .get(ARG_STATEMENT);

        final Long workitemId = (Long)args
            .get(ARG_WID);
        final Long id = (Long)args
            .get(ARG_ID);
        final Long parentId = (Long)args
            .get(ARG_PID);

        //
        // insert self
        
        insert(st, workitemId, id, parentId, this.getRepresentationName());

        //
        // encode children
        
        final ListAttribute la = (ListAttribute)a;

        long availableId = id.longValue()+1;

        final java.util.Iterator it = la.iterator();
        while (it.hasNext())
        {
            final java.util.Map childParams = prepareParams
                (st, workitemId, availableId, id.longValue());

            final Attribute child = (Attribute)it.next();

            Long aId = (Long)getWorkItemCoder().getAttributeCoder(child)
                .encode(child, childParams);

            availableId = aId.longValue();
        }
        
        //
        // that's all folks !

        return new Long(availableId);
    }

    public Attribute decode (final Object o, final java.util.Map args) 
        throws CodingException
    {
        final java.util.List attributeRecordList = AbstractSqlAttributeCoder
            .fetchAttributeRecordList(args);

        final Long attId = (Long)o;

        SqlWorkItemCoder.removeRecord(attributeRecordList, attId);

        ListAttribute result = null;
        try
        {
            final Class attributeClass = Class.forName(this.attributeClassName);
            result = (ListAttribute)attributeClass.newInstance();
        }
        catch (Exception e)
        {
            throw new CodingException
                ("Failed instantiate list attribute", e);
        }

        final java.util.List entries = SqlWorkItemCoder
            .lookupRecords(attributeRecordList, attId.longValue());

        final java.util.Iterator it = entries.iterator();
        while (it.hasNext())
        {
            final SqlWorkItemCoder.AttributeRecord record = 
                (SqlWorkItemCoder.AttributeRecord)it.next();

            result.add(decodeChild(record.id, record.type, args));
        }

        return result;
    }

}
