/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: CollectionAttributeCoder.java 3118 2006-08-30 14:38:36Z jmettraux $
 */

//
// CollectionAttributeCoder.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.worklist.impl.swis;

import openwfe.org.sql.SqlUtils;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.AttributeCoder;
import openwfe.org.engine.workitem.ListAttribute;
import openwfe.org.engine.workitem.CodingException;


/**
 * no comment
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 16:38:36 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: CollectionAttributeCoder.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class CollectionAttributeCoder

    extends AbstractSqlAttributeCoder

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(CollectionAttributeCoder.class.getName());

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    //
    // METHODS from AttributeCoder

    protected void insert
        (final java.sql.Statement st,
         final Long workitemId, 
         final Long id, 
         final Long parentId, 
         final String representationName)
    throws 
        CodingException
    {
        final java.util.List values = 
            new java.util.ArrayList(SqlWorkItemCoder.ATTRIBUTE_COLS.length);
        values.add( workitemId.toString() );
        values.add( id.toString() );
        values.add( parentId.toString() );
        values.add(representationName);
        values.add(null);

        final String sInsert = SqlUtils.buildInsertString
            (SqlWorkItemCoder.ATTRIBUTE_TABLE,
             SqlWorkItemCoder.ATTRIBUTE_COLS,
             values);

        try
        {
                log.debug( "addBatch() " + sInsert );
            st.addBatch(sInsert);
        }
        catch (java.sql.SQLException se)
        {
            log.warn
                ("Failed to prepare insert string with >>>\n"+sInsert+"\n<<<");
            throw new CodingException
                ("Failed to prepare insert string", se);
        }
    }

    protected Attribute decodeChild 
        (final long id, 
         final String representationName, 
         final java.util.Map args)
    throws
        CodingException
    {
        return ((SqlWorkItemCoder)this.getWorkItemCoder())
            .getAttributeCoder(representationName)
                .decode(new Long(id), args);
    }

}
