/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: BasicActionDaemon.java 3118 2006-08-30 14:38:36Z jmettraux $
 */

//
// ActionDaemon.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.worklist.impl.swis;

import openwfe.org.ApplicationContext;
import openwfe.org.sql.SqlUtils;
import openwfe.org.sql.ds.OwfeDataSource;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.participants.Participant;
import openwfe.org.engine.participants.ParticipantMap;
import openwfe.org.worklist.store.StoreException;


/**
 * The basic implementation of the action daemon.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: BasicActionDaemon.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 * @author jay.lawrence@openwfe.org
 */
public class BasicActionDaemon

    extends ActionDaemon

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(BasicActionDaemon.class.getName());

    //
    // CONSTANTS & co

    /**
     * The action name for proceeding a workitem
     */
    public final static String A_PROCEED
        = "proceed";

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    public void run ()
    {
        log.debug("run() daemon waking up");
        try
        {
            final OwfeDataSource ds = SqlUtils.lookupDataSource
                (this.applicationContext, 
                 this.serviceParams);

            final java.util.List entries = SqlWorkItemCoder
                .listActionEntries(ds);

            log.debug("run() entries to handle : "+entries.size());

            final java.util.Iterator it = entries.iterator();
            while (it.hasNext())
            {
                final ActionEntry ae = (ActionEntry)it.next();

                log.debug("run() '"+ae.action+"' -> "+ae.workitemId);

                if (ae.action.equals(A_PROCEED))
                {
                    //
                    // patch #1004139 (Jay Lawrence)
                    //
                    try
                    {
                        final InFlowWorkItem wi = (InFlowWorkItem)getCoder()
                            .decode
                                (new Long(ae.workitemId), 
                                 this.applicationContext, 
                                 this.serviceParams);

                        proceedWorkitem(wi);

                        SqlWorkItemCoder.removeActionEntry(ds, ae);
                    }
                    catch (Exception e)
                    {

                        SqlWorkItemCoder.errorActionEntry
                            (ds, ae, e.toString() );

                        log.error
                            ("run() proceeding workitem "+ae.workitemId+
                             " failed : ", 
                             e);
                    }
                    //
                    //
                }
            }

            log.debug("run() daemon going back to sleep.");
        }
        catch (final Exception e)
        {
            log.warn("run() failure", e);
        }
    }

    protected void proceedWorkitem (final InFlowWorkItem wi)
        throws StoreException
    {
        //
        // find participant
        
        final ParticipantMap pMap = openwfe.org.engine.Definitions
            .getParticipantMap(this.applicationContext);

        Participant p = pMap.get(wi.getLastExpressionId().getEngineId());

        if (p == null)
        {
            throw new StoreException
                ("Cannot delegate to unknown engineId '"+
                 wi.getLastExpressionId().getEngineId()+"'");
        }

        //
        // dispatch
        
        try
        {
            p.dispatch(this.applicationContext, wi);
        }
        catch (DispatchingException de)
        {
            throw new StoreException
                ("Failed to dispatch to engine '"+
                 wi.getLastExpressionId().getEngineId()+"'", de);
        }

        //
        // remove from store

        getStore().removeWorkItem(wi.getLastExpressionId());
    }

    //
    // STATIC METHODS

}
