/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: AtomicAttributeCoder.java 3257 2006-09-10 13:05:34Z jmettraux $
 */

//
// AtomicAttributeCoder.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.worklist.impl.swis;

import openwfe.org.sql.SqlUtils;
import openwfe.org.util.ReflectionUtils;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.CodingException;
import openwfe.org.engine.workitem.WorkItemCoder;


/**
 * Encoding atomic attributes
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-09-10 15:05:34 +0200 (Sun, 10 Sep 2006) $
 * <br>$Id: AtomicAttributeCoder.java 3257 2006-09-10 13:05:34Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class AtomicAttributeCoder

    extends AbstractSqlAttributeCoder

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(AtomicAttributeCoder.class.getName());

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    //
    // METHODS from AttributeCoder

    public Object encode (final Attribute a, final java.util.Map args)
        throws CodingException
    {
        final java.sql.Statement st = (java.sql.Statement)args
            .get(ARG_STATEMENT);

        final Long workitemId = (Long)args
            .get(ARG_WID);
        final Long id = (Long)args
            .get(ARG_ID);
        final Long parentId = (Long)args
            .get(ARG_PID);

        java.util.List values = 
            new java.util.ArrayList(SqlWorkItemCoder.ATTRIBUTE_COLS.length);
        values.add( workitemId.toString() );
        values.add( id.toString() );
        values.add( parentId.toString() );
        values.add(this.getRepresentationName());
        values.add(a.toString());

        String sInsert = SqlUtils.buildInsertString
            (SqlWorkItemCoder.ATTRIBUTE_TABLE,
             SqlWorkItemCoder.ATTRIBUTE_COLS,
             values);

        try
        {
            log.debug("addBatch() "+sInsert );
            st.addBatch(sInsert);
        }
        catch (java.sql.SQLException se)
        {
            log.warn
                ("Failed to prepare insert string with >>>\n"+sInsert+"\n<<<");
            throw new CodingException
                ("Failed to prepare insert string", se);
        }

        return new Long(id.longValue()+1);
    }

    public Attribute decode (final Object o, final java.util.Map args) 
        throws CodingException
    {
        final java.util.List attributeRecordList = AbstractSqlAttributeCoder
            .fetchAttributeRecordList(args);

        final Long attId = (Long)o;

        final SqlWorkItemCoder.AttributeRecord record =
            SqlWorkItemCoder.lookupRecord(attributeRecordList, attId);

        SqlWorkItemCoder.removeRecord(attributeRecordList, attId);

        try
        {
            return (Attribute)ReflectionUtils.buildInstance
                (Class.forName(this.attributeClassName), 
                 record.value);
        }
        catch (Exception e)
        {
            throw new CodingException
                ("Failed to decode attribute", e);
        }
    }

}
