/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ActionDaemon.java 3118 2006-08-30 14:38:36Z jmettraux $
 */

//
// ActionDaemon.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.worklist.impl.swis;

import openwfe.org.ApplicationContext;


/**
 * The beginning of the implementation of an ActionDaemon.
 * See BasicActionDaemon for more.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: ActionDaemon.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class ActionDaemon

    extends java.util.TimerTask

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ActionDaemon.class.getName());
    */

    //
    // CONSTANTS & co

    //
    // FIELDS

    protected ApplicationContext applicationContext = null;
    protected java.util.Map serviceParams = null;
    protected String storeName = null;

    //
    // CONSTRUCTORS

    /* implicit no parameter constructor */

    public void init 
        (final ApplicationContext context, 
         final java.util.Map serviceParams,
         final String storeName)
    {
        this.applicationContext = context;
        this.serviceParams = serviceParams;
        this.storeName = storeName;
    }

    //
    // METHODS

    /**
     * Returns the store this ActionDaemon belongs to
     */
    protected SqlWorkItemStore getStore ()
    {
        return (SqlWorkItemStore)this.applicationContext.get(this.storeName);
    }

    /**
     * Returns the workitem coder the store uses
     */
    protected SqlWorkItemCoder getCoder ()
    {
        return (SqlWorkItemCoder)getStore().getCoder();
    }

    //
    // STATIC METHODS

    /**
     * A small shortcut
     */
    public static ActionDaemon initActionDaemon
        (final String className, 
         final ApplicationContext context, 
         final java.util.Map params,
         final String storeName)
    throws 
        Exception
    {
        final Class clazz = Class.forName(className);
        final ActionDaemon daemon = (ActionDaemon)clazz.newInstance();
        daemon.init(context, params, storeName);
        return daemon;
    }

}
