/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: AbstractSqlAttributeCoder.java 3118 2006-08-30 14:38:36Z jmettraux $
 */

//
// AbstractSqlAttributeCoder.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.worklist.impl.swis;

import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.engine.impl.workitem.AbstractAttributeCoder;


/**
 * no comment
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 16:38:36 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: AbstractSqlAttributeCoder.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class AbstractSqlAttributeCoder

    extends AbstractAttributeCoder

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(AbstractSqlAttributeCoder.class.getName());

    //
    // CONSTANTS & co

    public final static String ATTRIBUTE_CLASS = "at-class";
    public final static String REPRESENTATION_NAME = "repr";

    public final static String ARG_WID = "arg-workitemid";
    public final static String ARG_ID = "arg-id";
    public final static String ARG_PID = "arg-parent-id";
    public final static String ARG_STATEMENT = "arg-statement";

    public final static String ARG_ATT_RECORD_LIST = "arg-attributeRecord-list";
    
    //
    // FIELDS

    protected String attributeClassName = null;
    protected String representationName = null;

    //
    // CONSTRUCTORS

    public void init 
        (final WorkItemCoder workItemCoder, final java.util.Map params)
    {
        super.init(workItemCoder, params);

        this.attributeClassName = (String)params.get(ATTRIBUTE_CLASS);
        this.representationName = (String)params.get(REPRESENTATION_NAME);

        if (this.attributeClassName == null || 
            this.representationName == null)
        {
            throw new IllegalArgumentException
                ("Attribute '"+ATTRIBUTE_CLASS+
                 "' or '"+REPRESENTATION_NAME+
                 "' is missing from AttributeCoder configuration");
        }

        log.debug
            ("init() class '"+this.attributeClassName+
             "' as '"+this.representationName+"'");
    }

    //
    // METHODS

    public static java.util.List fetchAttributeRecordList 
        (final java.util.Map args)
    {
        return (java.util.List)args.get(ARG_ATT_RECORD_LIST);
    }

    //
    // METHODS from AttributeCoder

    public String getAttributeClassName ()
    {
        return this.attributeClassName;
    }

    public String getRepresentationName ()
    {
        return this.representationName;
    }

    //
    // STATIC METHODS

    public static java.util.Map prepareParams
        (final java.sql.Statement st,
         final Long workitemId,
         final long id,
         final long parentId)
    {
        final java.util.Map result = new java.util.HashMap(5);

        result.put(ARG_STATEMENT, st);
        result.put(ARG_WID, workitemId);
        result.put(ARG_ID, new Long(id));
        result.put(ARG_PID, new Long(parentId));

        return java.util.Collections.unmodifiableMap(result);
    }

}
