/*
 * Copyright (c) 2005-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: UserGetStrategy.java,v 1.1 2006/03/03 14:33:43 jmettraux Exp $
 */

//
// UserGetStrategy.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.worklist.impl.store;

import javax.security.auth.Subject;

import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.auth.BasicPrincipal;
import openwfe.org.query.QueryMap;
import openwfe.org.query.QueryException;
import openwfe.org.query.item.QueryItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.worklist.store.GetStrategy;
import openwfe.org.worklist.store.StoreException;
import openwfe.org.worklist.store.WorkItemStore;


/**
 * Returns only workitems whose participant name is equals to the 
 * subject (user) requiring them.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: UserGetStrategy.java,v 1.1 2006/03/03 14:33:43 jmettraux Exp $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class UserGetStrategy

    extends ExtendedGetStrategy

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(UserGetStrategy.class.getName());

    //
    // CONSTANTS & co

    /**
     * By default, this UserGetStrategy will look for the target user of a
     * workitem by examining the '__username__' field; but by setting a value
     * for this 'usernameField' parameter, you can make it look for another
     * field.
     */
    public final static String P_USERNAME_FIELD
        = "usernameField";

    /* *
     * If this parameter is not set, all workitems are considered private, ie
     * only the user whose name is present in the field pointed at by 
     * 'usernameField' will see the workitem (the admin if any will also be
     * able to see the workitem;
     * When set, this parameter gives the name of a field whose expected value
     * is a boolean; 'true' means that only the user may see his workitems, 
     * 'false' means that everyone with access to the store.
     * /
    public final static String P_PRIVATE_FIELD
        = "privateField";
     */

    //
    // FIELDS

    private String usernameField = null;

    //
    // CONSTRUCTORS

    /**
     * Performs the initialization of the strategy (give it enough
     * info to do its task).
     */
    public void init 
        (final ApplicationContext context, 
         final WorkItemStore store, 
         final java.util.Map storeParams,
         final String storageName)
    throws
        StoreException
    {
        super.init(context, store, storeParams, storageName);

        this.usernameField = MapUtils.getAsString
            (storeParams, P_USERNAME_FIELD, "__username__");

        log.info
            ("init() will look for username in field '"+this.usernameField+"'");
    }

    //
    // METHODS

    //
    // METHODS from GetStrategy

    public java.util.List listWorkItems (final Subject s, final int limit)
        throws StoreException
    {
        //final String userName = BasicPrincipal.getBasicPrincipal(s).getName();
        final String userName = BasicPrincipal.getBasicPrincipal(s)
            .getOwfePrincipalName();

        if (log.isDebugEnabled())
            log.debug("listWorkItems() for '"+userName+"'");

        final java.util.List items = super.listWorkItems(s, limit);

        if (isAdmin(userName)) return items;

        final java.util.List results = new java.util.ArrayList(items.size());

        final java.util.Iterator it = items.iterator();
        while (it.hasNext())
        {
            final InFlowWorkItem item = 
                (InFlowWorkItem)it.next();

            final String wiUserName = 
                item.getAttributes().sget(this.usernameField);

            //if (userName.equals(wiUserName)
            if (this.equals(userName, wiUserName))
                results.add(item);
        }

        return results;
    }

    /**
     * Returns the name of the (workitem) field used to match the requesting 
     * user with the workitems he may see.
     */
    public String getUsernameField ()
    {
        return this.usernameField;
    }

    //
    // STATIC METHODS

}
