/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: StoreStat.java 3118 2006-08-30 14:38:36Z jmettraux $
 */

//
// StoreStat.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.worklist.impl.store;

import openwfe.org.Utils;


/**
 * This data class is just used to store stats for stores when getStatus()
 * is called on a storage.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: StoreStat.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class StoreStat
{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(StoreStat.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    private java.util.Map storeMap = new java.util.HashMap(15);

    private Entry cumulatedStat = new Entry();

    //
    // CONSTRUCTORS

    //
    // METHODS

    /**
     * Adds an entry to the stat
     */
    public synchronized void put 
        (final String storeName, final String flowDef, final String flowId)
    {
        Entry e = (Entry)this.storeMap.get(storeName);

        if (e == null)
        {
            e = new Entry(storeName);
            this.storeMap.put(storeName, e);
        }

        e.put(flowDef, flowId);
        this.cumulatedStat.put(flowDef, flowId);
    }

    /**
     * Renders the whole stat
     */
    public synchronized org.jdom.Element render ()
    {
        final org.jdom.Element elt = new org.jdom.Element("stores");

        elt.addContent(this.cumulatedStat.render());

        final java.util.Iterator it = this.storeMap.values().iterator();
        while (it.hasNext())
        {
            final Entry e = (Entry)it.next();

            elt.addContent(e.render());
        }

        return elt;
    }

    //
    // INNER CLASSES

    private static class Entry
    {
        String storeName = null;
        java.util.Map itemsPerFlow = new java.util.HashMap();
        java.util.Map itemsPerInstance = new java.util.HashMap();

        public Entry ()
        {
        }

        public Entry (final String storeName)
        {
            this.storeName = storeName;
        }

        public synchronized void put (final String flowDef, final String flowId)
        {
            Utils.inc(itemsPerFlow, flowDef);
            Utils.inc(itemsPerInstance, flowId);
        }

        public synchronized org.jdom.Element render ()
        {
            String name = this.storeName;
            if (this.storeName == null) name = "cumulated";

            final org.jdom.Element result = new org.jdom.Element(name);

            java.util.Iterator it = this.itemsPerFlow.keySet().iterator();
            while (it.hasNext())
            {
                String flowDef = (String)it.next();
                Integer count = (Integer)this.itemsPerFlow.get(flowDef);

                org.jdom.Element eFlow = new org.jdom.Element("flow");
                eFlow.setAttribute("def", flowDef);
                eFlow.setAttribute("workitems", count.toString());

                result.addContent(eFlow);
            }

            it = this.itemsPerInstance.keySet().iterator();
            while (it.hasNext())
            {
                String flowId = (String)it.next();
                Integer count = (Integer)this.itemsPerInstance.get(flowId);

                org.jdom.Element eFlow = new org.jdom.Element("flow");
                eFlow.setAttribute("id", flowId);
                eFlow.setAttribute("workitems", count.toString());

                result.addContent(eFlow);
            }

            return result;
        }
    }

}
