/*
 * Copyright (c) 2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ExtendedGetStrategy.java,v 1.1 2006/03/03 14:33:43 jmettraux Exp $
 */

//
// ExtendedGetStrategy.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.worklist.impl.store;

import javax.security.auth.Subject;

import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.auth.BasicPrincipal;
import openwfe.org.query.QueryMap;
import openwfe.org.query.QueryException;
import openwfe.org.query.item.QueryItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.worklist.store.GetStrategy;
import openwfe.org.worklist.store.StoreException;
import openwfe.org.worklist.store.WorkItemStore;


/**
 * An abstract extension of DefaultGetStrategy, it's shared by UserGetStrategy
 * and ParticipantGetStrategy (at least for now).
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: ExtendedGetStrategy.java,v 1.1 2006/03/03 14:33:43 jmettraux Exp $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class ExtendedGetStrategy

    extends DefaultGetStrategy

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ExtendedGetStrategy.class.getName());

    //
    // CONSTANTS & co

    /**
     * Indicates to this strategy which user should be considered an admin
     * and therefore be allowed to see *every* workitem in the store that
     * uses this strategy.
     * This parameter value may be a comma separated list of usernames. 
     * Individual usernames may be regular expressions.
     */
    public final static String P_ADMIN_USERNAMES
        = "adminUsernames";

    /**
     * If this 'ignoreCase' parameter is set to 'true', participant names
     * or user names matching will be performed without caring about
     * the case.
     * By default, case is considered.
     */
    public final static String P_IGNORE_CASE
        = "ignoreCase";

    //
    // FIELDS

    private java.util.List adminUsernames = null;
    private boolean ignoreCase = false;

    //
    // CONSTRUCTORS

    /**
     * Performs the initialization of the strategy (give it enough
     * info to do its task).
     */
    public void init 
        (final ApplicationContext context, 
         final WorkItemStore store, 
         final java.util.Map storeParams,
         final String storageName)
    throws
        StoreException
    {
        super.init(context, store, storeParams, storageName);

        this.adminUsernames = MapUtils.getAsList
            (storeParams, P_ADMIN_USERNAMES);

        if (this.adminUsernames != null)
        {
            log.info
                ("init() admin usernames set to '"+
                 MapUtils.getAsString(storeParams, P_ADMIN_USERNAMES)+"'");
        }

        this.ignoreCase = 
            MapUtils.getAsBoolean(storeParams, P_IGNORE_CASE, false);

        log.info("init() ignore case ? "+this.ignoreCase);
    }

    //
    // METHODS

    /**
     * Returns the count of workitems (satisfying the query strategy 
     * criteria).
     */
    public int countWorkItems 
        (final Subject s)
    throws 
        StoreException
    {
        return listWorkItems(s, -1).size();
    }

    /**
     * Returns true if the given username is listed as an admin
     * (see the parameter P_ADMIN_USERNAMES).
     */
    protected boolean isAdmin (final String username)
    {
        if (this.adminUsernames == null ||
            this.adminUsernames.size() < 1)
        {
            return false;
        }

        final java.util.Iterator it = this.adminUsernames.iterator();
        while (it.hasNext())
        {
            final String regex = (String)it.next();

            if (this.equals(username, regex)) return true;
            if (username.matches(regex)) return true;
        }

        return false;
    }

    /**
     * Returns the list of usernames (or regular expressions) whose users
     * may see any workitems in the store using this strategy.
     */
    public java.util.List getAdminUsernames ()
    {
        return this.adminUsernames;
    }

    /**
     * Depending on the 'ignoreCase' parameter, this method
     * will check strings for equality with or without ignoring case.
     */
    public boolean equals (final String s1, final String s2)
    {
        if (s1 == null || s2 == null) return false;

        if (this.ignoreCase) return s1.equalsIgnoreCase(s2);

        return s1.equals(s2);
    }

    //
    // STATIC METHODS

}
