/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: DefaultPutStrategy.java 3443 2006-10-07 05:41:06Z jmettraux $
 */

//
// DefaultPutStrategy.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.worklist.impl.store;

import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.worklist.store.PutStrategy;
import openwfe.org.worklist.store.StoreException;


/**
 * The default put strategy : just storing the workitems.
 * Other implementations could introduce correlations to merge workitems
 * from different flows...
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: DefaultPutStrategy.java 3443 2006-10-07 05:41:06Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class DefaultPutStrategy

    extends AbstractStoreStrategy

    implements PutStrategy

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(DefaultPutStrategy.class.getName());
    */

    //
    // CONSTANTS & co

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    //
    // METHODS from PutStrategy

    /**
     * This implementation simply calls the underlying storage's 
     * storeWorkItem() method.
     */
    public void put (final InFlowWorkItem wi)
        throws StoreException
    {
        getStorage().storeWorkItem(getStoreName(), wi);
    }

    /**
     * Removes a workitem from the underlying storage.
     */
    public void remove (final FlowExpressionId id)
        throws StoreException
    {
        getStorage().removeWorkItem(getStoreName(), id);
    }

    /* *
     * Nothing to do in this implementation.
     * /
    public void unlock (final FlowExpressionId workitemId)
        throws StoreException
    {
        // haciendo nada
    }
     */

    //
    // STATIC METHODS

}
