/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: AbstractStoreStrategy.java 3118 2006-08-30 14:38:36Z jmettraux $
 */

//
// AbstractStoreStrategy.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.worklist.impl.store;

import openwfe.org.ApplicationContext;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.worklist.store.StoreStrategy;
import openwfe.org.worklist.store.StoreException;
import openwfe.org.worklist.store.WorkItemStore;
import openwfe.org.worklist.store.WorkItemStorage;


/**
 * Gathering information and methods common to put and get strategy 
 * implementations.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: AbstractStoreStrategy.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class AbstractStoreStrategy

    implements StoreStrategy

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(AbstractStoreStrategy.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    private ApplicationContext context = null;
    private WorkItemStore store = null;
    private java.util.Map storeParams = null;
    private String storageName = null;

    //
    // CONSTRUCTORS

    //
    // METHODS from StoreStrategy

    /**
     * Performs the initialization of the strategy (give it enough
     * info to do its task).
     */
    public void init 
        (final ApplicationContext context, 
         final WorkItemStore store, 
         final java.util.Map storeParams,
         final String storageName)
    throws
        StoreException
    {
        this.context = context;
        this.store= store;
        this.storeParams = storeParams;
        this.storageName = storageName;
    }

    //
    // METHODS

    /**
     * Returns the application context this strategy lives in.
     */
    public ApplicationContext getContext ()
    {
        return this.context;
    }

    public java.util.Map getStoreParams ()
    {
        return this.storeParams;
    }

    /**
     * Returns the name of the store for which this strategy is used.
     */
    public WorkItemStore getStore ()
    {
        return this.store;
    }

    /**
     * A short cut to get the parent store's name.
     */
    public String getStoreName ()
    {
        return this.store.getName();
    }

    /**
     * Returns the storage service with which this strategy's store works.
     */
    public WorkItemStorage getStorage ()
    {
        return (WorkItemStorage)this.context.get(this.storageName);
    }

    //
    // STATIC METHODS

}
