/*
 * Copyright (c) 2005-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: AbstractStorage.java 3443 2006-10-07 05:41:06Z jmettraux $
 */

//
// AbstractStorage.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.worklist.impl.store;

import openwfe.org.MapUtils;
import openwfe.org.AbstractService;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.engine.workitem.WorkItemCoderLoader;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.worklist.store.WorkItemStorage;


/**
 * The beginning of the implementation of a storage (fields and methods common
 * to the classic implementations of WorkItemStorage).
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: AbstractStorage.java 3443 2006-10-07 05:41:06Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class AbstractStorage

    extends AbstractService

    implements WorkItemStorage

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(AbstractStorage.class.getName());

    //
    // CONSTANTS & co

    /**
     * The parameter 'workItemCoder' should point to the name of a workitem 
     * coder as defined by the 'workItemCoderLoader' service.
     */
    public final static String P_WORKITEM_CODER
        = "workItemCoder";

    //
    // FIELDS

    private String workItemCoderName = null;

    //
    // CONSTRUCTORS

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        //
        // determine workitem coder
        
        this.workItemCoderName = MapUtils.getAsString
            (getParams(),
             P_WORKITEM_CODER);

        log.info("init() workItemCoder set to '"+this.workItemCoderName+"'");


        //
        // display OpenWFE version in logs
        
        log.info
            ("OpenWFE version : "+
             openwfe.org.engine.Definitions.OPENWFE_VERSION);
    }

    //
    // METHODS

    /**
     * Loads the workitem coder
     */
    protected WorkItemCoder getWorkItemCoder ()
    {
        final WorkItemCoderLoader coderLoader = openwfe.org.engine.Definitions
            .getWorkItemCoderLoader(getContext());

        if (this.workItemCoderName != null)
            return coderLoader.getCoder(this.workItemCoderName);

        return coderLoader.getDefaultCoder();
    }

    //
    // STATIC METHODS

}
