/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: WorkitemFieldQueryItem.java 3118 2006-08-30 14:38:36Z jmettraux $
 */

//
// WorkitemFieldQueryItem.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.worklist.impl.query;

import openwfe.org.query.QueryException;
import openwfe.org.query.QueryConfiguration;
import openwfe.org.query.sets.Set;
import openwfe.org.query.item.Query;
import openwfe.org.query.impl.item.XmlNameValueItem;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.InFlowWorkItem;


/**
 * no comment
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: WorkitemFieldQueryItem.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class WorkitemFieldQueryItem

    extends XmlNameValueItem

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(WorkitemFieldQueryItem.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    //
    // CONSTRUCTORS

    /**
     * Inits the query item (override).
     */
    public void init 
        (final QueryConfiguration conf, final Query parentQuery, final Object o)
    throws 
        QueryException
    {
        super.init(conf, parentQuery, o);

        log.debug("init() for '"+getName()+"'");
    }
    /* - */

    //
    // METHODS from QueryItem

    /**
     * Given a [queriable] instance, tells wether this instance satisfies the
     * query.
     */
    public boolean validate (final Object o)
        throws QueryException
    {
        final InFlowWorkItem wi = (InFlowWorkItem)o;

        final java.util.Iterator it = 
            wi.getAttributes().keySet().iterator();
        while (it.hasNext())
        {
            final StringAttribute aKey = (StringAttribute)it.next();

            if ( ! aKey.toString().matches(this.getName())) continue;

            log.debug
                ("validate() found matching key '"+aKey.toString()+"' ...");

            final Attribute aValue = (Attribute)wi.getAttributes().get(aKey);

            if (aValue.toString().matches(this.getValue()))
            {
                log.debug
                    ("validate() '"+aValue.toString()+
                     "' matches "+getValue()+"'");

                return true;
            }

            log.debug("validate() value doesn't match.");
        }

        log.debug
            ("validate() didn't find any matching field. Returning false.");
        
        return false;
    }

    /**
     * Not used, returns null.
     */
    public Set query (Object o)
        throws QueryException
    {
        return null;
    }

    //
    // METHODS

    //
    // STATIC METHODS

}
