/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: AuditedRmiWorkSession.java 3118 2006-08-30 14:38:36Z jmettraux $
 */

//
// AuditedRmiWorkSession.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.worklist.impl.audit;

import java.rmi.RemoteException;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import javax.security.auth.Subject;

import openwfe.org.MapUtils;
import openwfe.org.OpenWfeException;
import openwfe.org.ApplicationContext;
import openwfe.org.auth.PolicyService;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.worklist.Header;
import openwfe.org.worklist.Launchable;
import openwfe.org.worklist.WorkSession;
import openwfe.org.worklist.Definitions;
import openwfe.org.worklist.store.WorkItemStore;
import openwfe.org.worklist.LaunchException;
import openwfe.org.worklist.WorkListException;
import openwfe.org.worklist.auth.LaunchPermission;
import openwfe.org.worklist.auth.DelegationPermission;
import openwfe.org.worklist.impl.RmiWorkSession;
import openwfe.org.worklist.audit.AuditLogger;
import openwfe.org.worklist.store.StoreException;


/**
 * An extension of RmiWorkSession using AuditedSaveAction.<br>
 * This developement has been sponsored by http://www.obinary.com
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 16:38:36 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: AuditedRmiWorkSession.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class AuditedRmiWorkSession

    extends RmiWorkSession

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(AuditedRmiWorkSession.class.getName());

    //
    // CONSTANTS

    //
    // FIELDS

    //
    // CONSTRUCTORS

    /*
     * This constructor must be present to rethrow its super generated 
     * RemoteException.
     */
    public AuditedRmiWorkSession ()
        throws RemoteException
    {
        super();
    }

    //
    // METHODS from WorkSession

    //
    // remote methods

    /**
     * Audited implementation
     */
    public String launch (final String engineId, final LaunchItem item)
        throws RemoteException, OpenWfeException
    {
        auditLaunch(engineId, item);

        return super.launch(engineId, item);
    }

    /**
     * Audited implementation
     */
    public void save 
        (final String storeName, final InFlowWorkItem item)
    throws 
        RemoteException, WorkListException
    {
        audit("save", storeName, item);

        super.save(storeName, item);
    }

    /**
     * Audited implementation
     */
    public void forward 
        (final String storeName, final InFlowWorkItem item)
    throws 
        RemoteException, OpenWfeException
    {
        audit("proceed", storeName, item);

        // 'proceed' is a better term than 'forward'...

        super.forward(storeName, item);
    }

    //
    // METHODS

    protected void auditLaunch
        (final String engineId,
         final LaunchItem item)
    throws
        RemoteException
    {
        log.debug("auditLaunch()");

        //
        // iterate and log delta

        final AuditLogger logger = Definitions.getAuditLogger(getContext());

        if (logger == null)
            //
            // no audit logger
        {
            log.warn
                ("auditLaunch() failed to find "+
                 "any AuditLogger implementation under '"+
                 Definitions.S_AUDIT_LOGGER+
                 "'. Cannot log modification to workitems.");

            return;
        }

        //
        // log all field

        final java.util.Iterator it = 
            item.getAttributes().stringKeySet().iterator();
        while (it.hasNext())
        {
            final String fieldName = it.next().toString();

            final Attribute currentAttribute = item.getAttribute(fieldName);

            logger.logNewField
                (getSubject(), 
                 item,
                 "launch:"+engineId,
                 fieldName,
                 currentAttribute);
        }
    }

    /**
     * Does the job of comparing the original workitem and the incoming
     * one and logging the delta.
     */
    protected void audit 
        (final String actionName, 
         final String storeName,
         final InFlowWorkItem item)
    throws
        RemoteException, StoreException
    {
        log.debug("audit()");

        //
        // determine workitem store

        final WorkItemStore store = (WorkItemStore)getContext().get(storeName);

        //
        // fetch original workitem

        final InFlowWorkItem originalItem = 
            store.get(getSubject(), item.getLastExpressionId());

        //
        // iterate and log delta

        final AuditLogger logger = Definitions.getAuditLogger(getContext());

        if (logger == null)
            //
            // no audit logger
        {
            log.warn
                ("run() failed to find any AuditLogger implementation under '"+
                 Definitions.S_AUDIT_LOGGER+
                 "'. Cannot log modification to workitems.");

            return;
        }

        //
        // ok : iterate and log

        // looking for new or modified fields

        java.util.Iterator it = 
            item.getAttributes().stringKeySet().iterator();
        while (it.hasNext())
        {
            final String fieldName = it.next().toString();

            log.debug("audit() (n/m) considering field '"+fieldName+"'");

            final boolean isNewField = 
                ! originalItem.containsAttribute(fieldName);

            final Attribute currentAttribute = item.getAttribute(fieldName);

            if (isNewField)
            {
                logger.logNewField
                    (getSubject(), 
                     item,
                     actionName,
                     fieldName,
                     currentAttribute);
            }
            else
            {
                final Attribute originalAttribute =
                    originalItem.getAttribute(fieldName);

                if ( ! originalAttribute.equals(currentAttribute))
                {
                    logger.logFieldModification
                        (getSubject(), 
                         item,
                         actionName,
                         fieldName,
                         originalAttribute,
                         currentAttribute);
                }
            }
        }

        // looking for removed fields

        it = originalItem.getAttributes().stringKeySet().iterator();
        while (it.hasNext())
        {
            final String fieldName = it.next().toString();

            log.debug("audit() (r) considering field '"+fieldName+"'");

            if ( ! item.containsAttribute(fieldName))
            {
                logger.logFieldRemoval
                    (getSubject(),
                     item,
                     actionName,
                     fieldName);
            }
        }

        // audit done.
    }

}
