/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: XmlWorkItemAndHeaderCoder.java 3118 2006-08-30 14:38:36Z jmettraux $
 */

//
// XmlWorkItemAndHeaderCoder.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.worklist.impl;

import openwfe.org.Utils;
import openwfe.org.xml.XmlUtils;
import openwfe.org.engine.workitem.CodingException;
import openwfe.org.engine.workitem.StringMapAttribute;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.impl.workitem.xml.WicUtils;
import openwfe.org.engine.impl.workitem.xml.XmlWorkItemCoder;
import openwfe.org.worklist.Header;
import openwfe.org.worklist.HeaderCoder;


/**
 * Headers also have to be coded.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-30 16:38:36 +0200 (Wed, 30 Aug 2006) $
 * <br>$Id: XmlWorkItemAndHeaderCoder.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class XmlWorkItemAndHeaderCoder

    extends XmlWorkItemCoder

    implements HeaderCoder

{

    //
    // CONSTANTS & co

    public final static String HEADER = "header";
    public final static String LOCKED = "locked";

    public final static String E_HEADERS = "headers";
    public final static String E_FEIS = "flow-expression-ids";

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS from HeaderCoder

    //
    // encoding

    public byte[] encodeHeader (Header h)
        throws CodingException
    {
        org.jdom.Element eHeader = encodeAsXml(h);

        try
        {
            return XmlUtils.toByteArray(eHeader);
        }
        catch (openwfe.org.OpenWfeException owe)
        {
            throw new CodingException
                ("Failed to encoder header", owe);
        }
    }

    /*
    public org.jdom.Element encodeAsXml (final java.util.List list)
        throws CodingException
    {
        //if (list == null || list.size() < 1)
        //    return new org.jdom.Element("empty");

        final Object o = list.get(0);

        if (o instanceof Header)
            return encodeHeaders(list);
        else if (o instanceof FlowExpressionId)
            return encodeFlowExpressionIds(list);

        throw new IllegalArgumentException
            ("cannot encode list of "+o.getClass().getName()+" instances");
    }
    */

    public org.jdom.Element encodeHeadersAsXml
        (final java.util.List headers)
    throws 
        CodingException
    {
        final org.jdom.Element eHeaders = new org.jdom.Element(E_HEADERS);

        final java.util.Iterator it = headers.iterator();
        while (it.hasNext())
            eHeaders.addContent(encodeAsXml((Header)it.next()));

        return eHeaders;
    }

    public org.jdom.Element encodeIdsAsXml
        (final java.util.List feis)
    throws 
        CodingException
    {
        org.jdom.Element eFeis = new org.jdom.Element(E_FEIS);

        java.util.Iterator it = feis.iterator();
        while (it.hasNext())
            eFeis.addContent(encode((FlowExpressionId)it.next()));

        return eFeis;
    }

    public org.jdom.Element encodeAsXml (Header h)
        throws CodingException
    {
        org.jdom.Element eh = new org.jdom.Element(HEADER);

        //Utils.setAttribute(eh, STRING_ID, h.getStringId());
            // transient...
        WicUtils.setAttribute(eh, LAST_MODIFIED, ""+h.getLastModified());
        WicUtils.setAttribute(eh, LOCKED, ""+h.isLocked());

        //
        // workitem id
        
        eh.addContent(encode(h.getExpressionId()));

        //
        // attributes
        
        org.jdom.Element as = new org.jdom.Element(ATTRIBUTES);
        org.jdom.Element smap = encodeAttribute(h.getAttributes());
        if (smap != null) as.addContent(smap);
        eh.addContent(as);

        return eh;
    }

    //
    // decoding

    public Header decodeHeader (Object o)
        throws CodingException
    {
        org.jdom.Document doc = fetchDocument(o);

        org.jdom.Element rootElt = doc.getRootElement();

        if ( ! rootElt.getName().equals(HEADER))
        {
            throw new CodingException
                ("Cannot decode <"+rootElt.getName()+
                 "> instead of <"+HEADER+">");
        }

        Header h = new Header();

        h.setLastModified(rootElt.getAttributeValue(LAST_MODIFIED));

        String sLocked = rootElt.getAttributeValue(LOCKED);
        h.setLocked(sLocked != null && sLocked.toLowerCase().equals("true"));

        //
        // expression id
        
        h.setExpressionId
            (decodeFlowExpressionId(rootElt.getChild(FLOW_EXPRESSION_ID)));

        //
        // attributes
        
        org.jdom.Element attElt = rootElt.getChild(ATTRIBUTES);
        attElt = attElt.getChild("smap");

        h.setAttributes
            ((StringMapAttribute)getAttributeCoder("smap")
                .decode(attElt, null));

        // done

        return h;
    }

    //
    // OVERRIDDEN METHODS (if any)

    //
    // METHODS

}
