/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: XmlHeaderFactory.java 3118 2006-08-30 14:38:36Z jmettraux $
 */

//
// XmlHeaderFactory.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.00 16.08.2003 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.worklist.impl;

import openwfe.org.FileUtils;
import openwfe.org.MapUtils;
import openwfe.org.AbstractService;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.xml.XmlUtils;
import openwfe.org.engine.workitem.LongAttribute;
import openwfe.org.engine.workitem.StringMapAttribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.worklist.Header;
import openwfe.org.worklist.HeaderFactory;
import openwfe.org.worklist.WorkListException;


/**
 * Usually, this class reads its configuration from 
 * etc/worklist/header-factory.xml
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: XmlHeaderFactory.java 3118 2006-08-30 14:38:36Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class XmlHeaderFactory

    extends AbstractService

    implements HeaderFactory

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(XmlHeaderFactory.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    private java.util.List attributes = null;
    private java.util.Map scope = null;

    //
    // CONSTRUCTORS

    //
    // METHODS from Service

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        listAttributes();
    }

    public org.jdom.Element getStatus ()
    {
        org.jdom.Element result = new org.jdom.Element(getName());

        result.addContent(XmlUtils.getClassElt(this));
        result.addContent(XmlUtils.getRevisionElt("$Id: XmlHeaderFactory.java 3118 2006-08-30 14:38:36Z jmettraux $"));

        return result;
    }

    //
    // METHODS from HeaderFactory

    public Header buildHeader (final InFlowWorkItem wi, final String lockerName)
        throws WorkListException
    {
        final Header header = new Header();

        //
        // workitem id
        
        header.setExpressionId(wi.getLastExpressionId());

        //
        // last modified

        header.setLastModified(wi.getLastModified());

        //
        // classical attributes

        final StringMapAttribute attributes = new StringMapAttribute();

        //log.debug("buildHeader() attributes is          "+attributes);
        //log.debug("buildHeader() wi is                  "+wi);
        //log.debug("buildHeader() wi.lastExpressionId is "+wi.getLastExpressionId());

        attributes.puts
            (Header.WF_INSTANCE_ID, 
             wi.getLastExpressionId().getWorkflowInstanceId());

        attributes.puts
            (Header.WF_DEFINITION_NAME, 
             wi.getLastExpressionId().getWorkflowDefinitionName());

        attributes.puts
            (Header.WF_DEFINITION_REVISION, 
             wi.getLastExpressionId().getWorkflowDefinitionRevision());

        attributes.puts
            (Header.WF_DEFINITION_URL, 
             wi.getLastExpressionId().getWorkflowDefinitionUrl());

        attributes.puts
            (Header.DISPATCH_TIME,
             wi.getDispatchTime());

        //log.debug
        //    ("buildHeader() wi.dispatchTime is >"+wi.getDispatchTime()+"<");

        attributes.puts
            (Header.PARTICIPANT_NAME,
             wi.getParticipantName());

        if (lockerName != null)
        {
            header.setLocked(true);

            attributes.puts(Header.LOCKER_NAME, lockerName);
        }

        //
        // xml defined attributes
        
        final java.util.Iterator it = this.attributes.iterator();
        while (it.hasNext())
        {
            final HeaderAttribute ha = (HeaderAttribute)it.next();

            attributes.puts
                (ha.getName(),
                 ha.getValue(this.scope, wi).trim());
        }

        //

        header.setAttributes(attributes);

        return header;
    }

    //
    // METHODS

    public void listAttributes ()
        throws ServiceException
    {
        this.attributes = new java.util.ArrayList(20);

        //
        // determine configuration file

        String configFileName = MapUtils
            .getMandatoryString(getParams(), CONFIGURATION_FILE);

        configFileName = FileUtils.expandUrl
            (getContext().getApplicationDirectory(), configFileName);

        //
        // parse configuration file
        
        org.jdom.Element rootElt = null;
        try
        {
            rootElt = XmlUtils.extractXml(configFileName, false);
        }
        catch (Exception e)
        {
            throw new ServiceException
                ("Failed to parse config file "+configFileName, e);
        }

        java.util.Iterator it = 
            rootElt.getChildren("header-attribute").iterator();
        while (it.hasNext())
        {
            org.jdom.Element elt = (org.jdom.Element)it.next();
            this.attributes.add(new HeaderAttribute(elt));
        }

        this.scope = new java.util.HashMap();
        it = rootElt.getChildren("set").iterator();
        while (it.hasNext())
        {
            org.jdom.Element elt = (org.jdom.Element)it.next();

            this.scope.put
                (elt.getAttributeValue("name"), 
                 elt.getAttributeValue("value"));
        }
    }

    //
    // INNER CLASSES

    class HeaderAttribute
    {
        final static String NAME = "name";
        final static String REFERENCE = "ref";
        final static String WI_ATTRIBUTE = "workitem-attribute";
        final static String WI_ATTRIBUTE_IP = "workitem-attribute-ispresent";

        private String name = null;
        private java.util.List items = null;

        public HeaderAttribute (org.jdom.Element elt)
        {
            this.name = elt.getAttributeValue(NAME);

            this.items =
                new java.util.ArrayList(elt.getContent().size());

            java.util.Iterator it = elt.getContent().iterator();
            while (it.hasNext())
            {
                Object o = it.next();

                if (o instanceof org.jdom.Text)
                {
                    //log.debug("HeaderAttribute - building a Text item");

                    Text t = new Text();
                    t.init(o);

                    this.items.add(t);
                }
                else if (o instanceof org.jdom.Element)
                {
                    org.jdom.Element e = (org.jdom.Element)o;

                    if (e.getName().equals(WI_ATTRIBUTE))
                    {
                        //log.debug("HeaderAttribute - building a WorkitemAttribute item");

                        WorkitemAttribute wa = new WorkitemAttribute();
                        wa.init(e);

                        this.items.add(wa);
                    }
                    else if (e.getName().equals(REFERENCE))
                    {
                        //log.debug("HeaderAttribute - building a Reference item");

                        Reference r = new Reference();
                        r.init(e);

                        this.items.add(r);
                    }
                    else if (e.getName().equals(WI_ATTRIBUTE_IP))
                    {
                        final WorkitemAttributeIsPresent waip = 
                            new WorkitemAttributeIsPresent();
                        waip.init(e);

                        this.items.add(waip);
                    }
                }
            }
        }

        public String getName () { return this.name; }

        public String getValue (java.util.Map scope, InFlowWorkItem wi)
        {
            //log.debug("getValue() for HeaderAttribute named '"+this.name+"'");

            StringBuffer sb = new StringBuffer();

            java.util.Iterator it = this.items.iterator();
            while (it.hasNext())
            {
                Item i = (Item)it.next();

                sb.append(i.getValue(scope, wi));
            }

            //log.debug("getValue() returns >"+sb.toString()+"<");

            return sb.toString();
        }
    }

    interface Item
    {
        public void init (Object o);

        public String getValue (java.util.Map scope, InFlowWorkItem wi);
    }

    class Text implements Item
    {
        private String value = null;

        public void init (Object o)
        {
            org.jdom.Text text = (org.jdom.Text)o;
            this.value = text.getText();
        }

        public String getValue (java.util.Map scope, InFlowWorkItem wi)
        {
            //log.debug("Text.getValue() >"+this.value+"<");

            return this.value;
        }
    }

    class WorkitemAttribute implements Item
    {
        private String workitemAttributeName = null;
        private String defaultValue = null;

        public void init (Object o)
        {
            org.jdom.Element elt = (org.jdom.Element)o;

            this.workitemAttributeName = elt.getAttributeValue("name");

            if (this.workitemAttributeName != null)
                this.workitemAttributeName = this.workitemAttributeName.trim();

            this.defaultValue = elt.getAttributeValue("default");

            if (this.defaultValue == null) 
                this.defaultValue = "null";
        }

        public String getWorkitemAttributeName ()
        {
            return this.workitemAttributeName;
        }

        public String getValue (java.util.Map scope, InFlowWorkItem wi)
        {
            if (this.workitemAttributeName == null) return null;

            Object value = wi.getAttribute(this.workitemAttributeName);

            if (value == null) return this.defaultValue;

            return String.valueOf(value);
        }
    }

    class WorkitemAttributeIsPresent extends WorkitemAttribute
    {
        public String getValue 
            (final java.util.Map scope, final InFlowWorkItem wi)
        {
            if (getWorkitemAttributeName() == null) return null;

            if (wi.getAttribute(getWorkitemAttributeName()) != null)
                return "true";

            return "false";
        }
    }

    class Reference implements Item
    {
        String referenceTo = null;

        public void init (Object o)
        {
            org.jdom.Element elt = (org.jdom.Element)o;

            this.referenceTo = elt.getAttributeValue("name");

            if (this.referenceTo != null) 
                this.referenceTo = this.referenceTo.trim();
        }

        public String getValue (java.util.Map scope, InFlowWorkItem wi)
        {
            //log.debug("Reference.getValue() >"+scope.get(this.referenceTo)+"<");

            return (String)scope.get(this.referenceTo);
        }
    }

}
