/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: RmiWorkSession.java 3124 2006-08-31 01:01:38Z jmettraux $
 */

//
// RmiWorkSession.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.worklist.impl;

import java.rmi.RemoteException;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import javax.security.auth.Subject;

import openwfe.org.Service;
import openwfe.org.OpenWfeException;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.rmi.session.ClassedWorkSessionServer;
import openwfe.org.auth.Actions;
import openwfe.org.auth.PolicyService;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.worklist.Header;
import openwfe.org.worklist.Launchable;
import openwfe.org.worklist.WorkSession;
import openwfe.org.worklist.Definitions;
import openwfe.org.worklist.store.WorkItemStore;
import openwfe.org.worklist.LaunchException;
import openwfe.org.worklist.WorkListException;
import openwfe.org.worklist.auth.LaunchPermission;
import openwfe.org.worklist.auth.DelegationPermission;


/**
 * An implementation of WorkSession based on RMI.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-08-31 03:01:38 +0200 (Thu, 31 Aug 2006) $
 * <br>$Id: RmiWorkSession.java 3124 2006-08-31 01:01:38Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class RmiWorkSession

    extends java.rmi.server.UnicastRemoteObject

    implements WorkSession, Service

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(RmiWorkSession.class.getName());

    //
    // FIELDS

    private String serviceName = null;
    private ApplicationContext applicationContext = null;
    private java.util.Map serviceParams = null;
    private Subject subject = null;

    private java.util.Map ids = new java.util.HashMap();

    //
    // CONSTRUCTORS

    /*
     * This constructor must be present to rethrow its super generated 
     * RemoteException.
     */
    public RmiWorkSession ()
        throws RemoteException
    {
        super();
    }

    //
    // METHODS from WorkSession

    //
    // non remote methods

    public void init 
        (final String serviceName,
         final ApplicationContext context, 
         final java.util.Map params)
         //final Object subject)
    throws 
        //RemoteException
        ServiceException
    {
        log.debug("init()");

        this.serviceName = serviceName;
        this.applicationContext = context;
        this.serviceParams = params;

        this.subject = 
            (Subject)params.get(ClassedWorkSessionServer.P_SUBJECT);

        if (this.subject == null) 
            log.warn("init() no subject passed.");
    }

    public String getName ()
    {
        return this.serviceName;
    }

    public Subject getSubject () 
    { 
        return this.subject; 
    }

    public ApplicationContext getContext ()
    {
        return this.applicationContext;
    }

    public java.util.Map getParams ()
    {
        return this.serviceParams;
    }

    public org.jdom.Element getStatus ()
    {
        return null; // no need to implement it now
    }

    //
    // remote methods
    //
    // (a lot of security wrapping)

    /*
     * This first method is unprotected : everybody (if authenticated)
     * may list the storeNames
     */
    public java.util.List getStoreNames ()
        throws RemoteException
    {
        final java.util.List result = new java.util.LinkedList();

        final java.util.Iterator it = 
            this.applicationContext.keySet().iterator();
        while (it.hasNext())
        {
            final String serviceName = (String)it.next();

            final Object o = this.applicationContext.lookup(serviceName);

            if (o instanceof WorkItemStore)
            {
                result.add(serviceName);

                if (log.isDebugEnabled())
                    log.debug("getStoreNames() taking '"+serviceName+"'");
            }
        }

        if (log.isDebugEnabled())
            log.debug("getStoreNames() found "+result.size()+" stores.");

        return result;
    }

    protected Object executeAction 
        (final String actionClassName,
         final Object[] args)
    throws 
        WorkListException,
        RemoteException
    {
        try
        {
            return Actions.executeAction
                (this.applicationContext,
                 this.subject,
                 actionClassName,
                 args);
        }
        catch (final PrivilegedActionException pae)
        {
            logException(actionClassName, pae.getException());

            throw new WorkListException
                ("failure 0 in "+actionClassName, pae.getException());
        }
        catch (final WorkListException we)
        {
            logException(actionClassName, we);

            throw we;
        }
        catch (final Throwable t)
        {
            logException(actionClassName, t);

            throw new WorkListException
                ("failure 1 in "+actionClassName, t);
        }

        // TODO : what about the RemoteException ???
    }

    protected void logException 
        (final String actionClassName, final Throwable t)
    {
        if (log.isDebugEnabled())
            log.warn("executeAction() failure for "+actionClassName, t);
        else
            log.warn("executeAction() failure for "+actionClassName+" : "+t);
    }

    public int countWorkItems (final String storeName)
        throws RemoteException, WorkListException
    {
        final Integer i = (Integer)executeAction
            ("openwfe.org.wlactions.CountWorkItemsAction",
             new Object[] { storeName });

        return i.intValue();
    }

    public java.util.List findFlowInstance
        (final String storeName, final String workflowInstanceId)
    throws 
        RemoteException, WorkListException
    {
        final java.util.List feis = (java.util.List)executeAction
            ("openwfe.org.wlactions.FindFlowInstanceAction",
             new Object[] { storeName, workflowInstanceId });

        registerIds(feis);

        return feis;
    }

    public java.util.List getHeaders 
        (final String storeName, final int limit)
    throws 
        RemoteException, WorkListException
    {
        final java.util.List headers = (java.util.List)executeAction
            ("openwfe.org.wlactions.GetHeadersAction",
             new Object[] { storeName, new Integer(limit) });

        registerIds(headers);

        return headers;
    }

    public java.util.List getHeaders 
        (final String storeName, 
         final int limit, 
         final java.util.Comparator headerComparator)
    throws 
        RemoteException, WorkListException
    {
        final java.util.List headers = (java.util.List)executeAction
            ("openwfe.org.wlactions.GetHeadersAction",
             new Object[] { storeName, new Integer(limit), headerComparator });

        registerIds(headers);
            //
            // strange, but in the old version, this step was omitted...

        return headers;
    }

    public InFlowWorkItem get 
        (final String storeName, final FlowExpressionId fei)
    throws 
        RemoteException, WorkListException
    {
        return (InFlowWorkItem)executeAction
            ("openwfe.org.wlactions.GetAction",
             new Object[] { storeName, fei });
    }

    public InFlowWorkItem get 
        (final String storeName, final String id)
    throws 
        RemoteException, WorkListException
    {
        return get(storeName, (FlowExpressionId)this.ids.get(id));
    }

    public InFlowWorkItem getAndLock 
        (final String storeName, final FlowExpressionId fei)
    throws 
        RemoteException, WorkListException
    {
        //if (log.isDebugEnabled())
        //    log.debug("getAndLock() storeName >"+storeName+"< fei "+fei);

        return (InFlowWorkItem)executeAction
            ("openwfe.org.wlactions.GetAndLockAction",
             new Object[] { storeName, fei });
    }

    public InFlowWorkItem getAndLock 
        (final String storeName, final String id)
    throws 
        RemoteException, WorkListException
    {
        return getAndLock(storeName, (FlowExpressionId)this.ids.get(id));
    }

    public void release 
        (final String storeName, final InFlowWorkItem item)
    throws 
        RemoteException, WorkListException
    {
        executeAction
            ("openwfe.org.wlactions.ReleaseAction",
             new Object[] { storeName, item });
    }

    public void save 
        (final String storeName, final InFlowWorkItem item)
    throws 
        RemoteException, WorkListException
    {
        executeAction
            ("openwfe.org.wlactions.SaveAction",
             new Object[] { storeName, item });
    }

    public void forward 
        (final String storeName, final InFlowWorkItem item)
    throws 
        RemoteException, OpenWfeException
    {
        proceed(storeName, item);
    }

    public void proceed
        (final String storeName, final InFlowWorkItem item)
    throws 
        RemoteException, OpenWfeException
    {
        executeAction
            ("openwfe.org.wlactions.ProceedAction",
             new Object[] { storeName, item });
    }

    /**
     * This method returns a list of Launchable instances, ie objects
     * pointing to workflow definitions the user is authorized to launch.
     */
    public java.util.List getLaunchables ()
        throws RemoteException, WorkListException
    {
        java.util.List launchPermissions = 
            getPermissions(LaunchPermission.class);

        //
        // build launchables out of launch permissions
        
        java.util.Map result = new java.util.HashMap();

        java.util.Iterator it = launchPermissions.iterator();
        while (it.hasNext())
        {
            LaunchPermission lp = (LaunchPermission)it.next();
            java.util.Iterator lit = lp.resolveUrl().iterator();
            while (lit.hasNext())
            {
                String url = null;
                try
                {
                    url = (String)lit.next();

                    if (url.indexOf(".*") > -1) continue;

                    result.put
                        (url, 
                         new Launchable
                            (this.applicationContext, 
                             this.serviceParams, 
                             lp.getEngineId(), 
                             url));
                }
                catch (final LaunchException le)
                {
                    log.info
                        ("Failed to build launchable for "+
                         lp.getEngineId()+"::"+url);
                }
            }
        }

        //
        // return result
        
        java.util.ArrayList keys = new java.util.ArrayList(result.keySet());
        java.util.Collections.sort(keys);

        java.util.ArrayList launchables = new java.util.ArrayList(keys.size());

        it = keys.iterator();

        while (it.hasNext()) 
            launchables.add(result.get(it.next()));

        return launchables;
    }

    public String launch (final String engineId, final LaunchItem item)
        throws RemoteException, OpenWfeException
    {
        final Object result = executeAction
            ("openwfe.org.wlactions.LaunchAction",
             new Object[] { engineId, item });

        if (result instanceof FlowExpressionId)
            return ((FlowExpressionId)result).toParseableString();

        return result.toString();
    }

    public void delegate 
        (String storeName, InFlowWorkItem item, String targetStoreName)
    throws RemoteException, WorkListException
    {
        executeAction
            ("openwfe.org.wlactions.DelegateAction",
             new Object[] { storeName, item, targetStoreName });
    }

    public java.util.List getParticipantsForDelegation ()
        throws RemoteException, WorkListException
    {
        java.util.List delegationPermissions = 
            getPermissions(DelegationPermission.class);

        java.util.List result = 
            new java.util.ArrayList(delegationPermissions.size());

        java.util.Iterator it = delegationPermissions.iterator();
        while (it.hasNext())
        {
            DelegationPermission dp = (DelegationPermission)it.next();
            result.add(dp.getName());
        }

        return result;
    }

    public void delegateToParticipant
        (String storeName, InFlowWorkItem item, String participantName)
    throws 
        RemoteException, WorkListException
    {
        executeAction
            ("openwfe.org.wlactions.DelegateToParticipantAction",
             new Object[] { storeName, item, participantName });
    }

    public boolean checkPermission (String storeName, String action)
        throws RemoteException, WorkListException
    {
        if (log.isDebugEnabled())
        {
            log.debug
                ("checkPermission() action >"+action+"< on '"+storeName+"'");
        }

        final Boolean b = (Boolean)executeAction
            ("openwfe.org.wlactions.CheckPermissionAction",
             new Object[] { storeName, action });

        return b.booleanValue();
    }
    
    /**
     * Terminates this worksession.
     */
    public void close ()
        throws RemoteException
    {
        //
        // TODO : remove all locks !
    }

    //
    // OTHER METHODS

    /*
     * Keeps a map of the ' flow expression ids with the 
     * string id as key and with the workitem as values.
     */
    private void registerIds (final java.util.List l)
    {
        final java.util.Iterator it = l.iterator();
        while (it.hasNext())
        {
            final Object o = it.next();

            FlowExpressionId fei = null;

            if (o instanceof Header)
            {
                fei = ((Header)o).getExpressionId();
            }
            else if (o instanceof FlowExpressionId)
            {
                fei = (FlowExpressionId)o;
            }
            else
            {
                throw new IllegalArgumentException
                    ("Couldn't register flow expression id "+
                     "out of object of class "+o.getClass().getName());
            }

            this.ids.put(fei.asStringId(), fei);
        }
    }

    protected java.util.List getPermissions (Class permissionClass)
        throws WorkListException
    {
        //
        // get policy service
        
        PolicyService policy = 
            PolicyService.lookupPolicyService(this.applicationContext);
        policy.refresh();

        //
        // get permissions
        
        PermissionCollection permissions = null;
        try
        {
            permissions = policy.getPermissions(this.subject);
        }
        catch (openwfe.org.auth.AuthException ae)
        {
            throw new WorkListException
                ("Failed to list permissions for subject", ae);
        }

        //
        // take out valid permissions
        
        java.util.List result = new java.util.ArrayList();

        java.util.Enumeration en = permissions.elements();
        while (en.hasMoreElements())
        {
            Object o = en.nextElement();

            if (permissionClass.isAssignableFrom(o.getClass())) 
                result.add(o);
        }

        //
        // return result
        
        return result;
    }

}
